
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [35, 25, 15, 10, 8, 7]  # Representing the proportion of each tourist destination
labels = [
    "Paris\n35%",
    "New York\n25%",
    "Tokyo\n15%",
    "Rome\n10%",
    "Sydney\n8%",
    "Cape Town\n7%",
]
title = "Market Share of Global Tourist Destinations"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b"]
# Create a figure with the specified size
fig = plt.figure(figsize=(10, 8))

# Create a treemap
squarify.plot(
    sizes=sizes,
    label=labels,
    color=colors,
    alpha=0.85,
    text_kwargs={"fontsize": 14, "color": "black"},
    pad=True,
    ec="white",
)

# Add a title
plt.title(title, fontsize=18)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_77.pdf", bbox_inches="tight")
