
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data for communication technologies
data_4G = np.random.normal(0.75, 0.05, 200)
data_5G = np.random.normal(0.85, 0.04, 200)
data_WiFi = np.random.normal(0.65, 0.08, 200)
data_Satellite = np.random.normal(0.55, 0.1, 200)

# Chart labels and settings
xticklabels = ["4G", "5G", "Wi-Fi", "Satellite"]
ylabel = "Connection Reliability"
xlabel = "Technology"
title = "Connection Reliability of Different Communication Technologies"
ylim = [0.2, 1.0]
xticks = [1, 2, 3, 4]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with specified dimensions
fig, ax = plt.subplots(figsize=(7, 5))

# Create violin plots
violin_parts1 = ax.violinplot(data_4G, positions=[1], showmeans=True)
violin_parts2 = ax.violinplot(data_5G, positions=[2], showmeans=True)
violin_parts3 = ax.violinplot(data_WiFi, positions=[3], showmeans=True)
violin_parts4 = ax.violinplot(data_Satellite, positions=[4], showmeans=True)

# Customize colors with modern colors
violin_parts1["bodies"][0].set_facecolor("#1f77b4")  # Blue
violin_parts2["bodies"][0].set_facecolor("#ff7f0e")  # Orange
violin_parts3["bodies"][0].set_facecolor("#2ca02c")  # Green
violin_parts4["bodies"][0].set_facecolor("#d62728")  # Red

# Change mean line colors to black for each violin plot
for violin_parts in [violin_parts1, violin_parts2, violin_parts3, violin_parts4]:
    for partname in ("cmeans", "cmaxes", "cmins", "cbars"):
        vp = violin_parts[partname]
        vp.set_edgecolor("black")
        vp.set_linewidth(1.5)

# Set x-axis and y-axis labels
ax.set_xticks(xticks)
ax.set_xticklabels(xticklabels)
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)

# Set title
ax.set_title(title)

# Set y-axis limits
ax.set_ylim(ylim)

# ===================
# Part 4: Saving Output
# ===================
# tight layout
plt.tight_layout()

# Save the plot
plt.savefig("violin_30.pdf", bbox_inches="tight")
