
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate sample transportation data
transport_modes = {
    "Mode 1": {
        "Car": np.random.normal(30, 5, 100),
        "Bicycle": np.random.normal(45, 10, 100),
    },
    "Mode 2": {
        "Bus": np.random.normal(40, 8, 100),
        "Train": np.random.normal(35, 7, 100),
    },
    "Mode 3": {
        "Car": np.random.normal(35, 6, 100),
        "Bicycle": np.random.normal(50, 12, 100),
    },
    "Mode 4": {
        "Bus": np.random.normal(42, 7, 100),
        "Train": np.random.normal(38, 6, 100),
    },
}

title = "Distribution of Travel Times (in minutes):"
xticklabels = ["Car/Bicycle", "Bus/Train"]
xticks = [1, 2]

# Prepare data for violin plot
data_to_plot = []
for mode_name, modes in transport_modes.items():
    data_to_plot.extend([times for mode, times in modes.items()])

# Text labels
xlabel = "Transportation Modes"
ylabel = "Travel Time (minutes)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and an array of axes: 2x2 subplot grid
fig, axs = plt.subplots(nrows=2, ncols=2, figsize=(12, 8))

# Define colors
colors = {
    "Car": "#ff9999",
    "Bicycle": "#66b3ff",
    "Bus": "#99ff99",
    "Train": "#ffcc99",
}

# Flatten the axes array for easy iteration
axs = axs.flatten()

for i, (mode_name, ax) in enumerate(zip(transport_modes, axs)):
    mode_times = transport_modes[mode_name]
    parts = ax.violinplot([mode_times["Car"], mode_times["Bicycle"]] if i % 2 == 0 else [mode_times["Bus"], mode_times["Train"]],
                          showmeans=True, showmedians=True)
    
    # Set the colors for each part of the violin
    for pc, color in zip(parts['bodies'], [colors["Car"], colors["Bicycle"]] if i % 2 == 0 else [colors["Bus"], colors["Train"]]):
        pc.set_facecolor(color)
        pc.set_edgecolor('black')
    ax.set_title(f"{title} {mode_name}")
    ax.set_xticks(xticks)
    ax.set_xticklabels(xticklabels)
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel)

# ===================
# Part 4: Saving Output
# ===================
# Improve spacing between subplots
plt.tight_layout()

plt.savefig("violin_45.pdf", bbox_inches="tight")
