
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate sample data for age distribution
age_distribution = {
    "Region 1": {
        "Males": np.random.normal(35, 10, 100),
        "Females": np.random.normal(38, 12, 100),
    },
    "Region 2": {
        "Males": np.random.normal(30, 15, 100),
        "Females": np.random.normal(32, 10, 100),
    },
    "Region 3": {
        "Males": np.random.normal(45, 14, 100),
        "Females": np.random.normal(42, 10, 100),
    },
    "Region 4": {
        "Males": np.random.normal(40, 9, 100),
        "Females": np.random.normal(44, 13, 100),
    },
}

title = "Age Distribution Across Regions"
xlabel = "Gender"
ylabel = "Age"
xticklabels = ["Males", "Females"]
xticks = [1, 2]
colors = ['#1f77b4', '#ff7f0e']  # Blue for Males, Orange for Females

# Prepare data for violin plot
data_to_plot = []
for region_name, genders in age_distribution.items():
    data_to_plot.extend([grades for gender, grades in genders.items()])

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and an array of axes: 2x2 subplot grid
fig, axs = plt.subplots(nrows=2, ncols=2, figsize=(12, 8))

# Flatten the axes array for easy iteration
axs = axs.flatten()

for i, (region_name, ax) in enumerate(zip(age_distribution, axs)):
    gender_ages = age_distribution[region_name]
    vp = ax.violinplot([gender_ages["Males"], gender_ages["Females"]], showmeans=True, showmedians=True)

    # Set custom color for each gender
    for pc, color in zip(vp['bodies'], colors):
        pc.set_facecolor(color)
        pc.set_edgecolor('black')
        pc.set_alpha(0.6)

    # Set title and labels
    ax.set_title(f"{title}: {region_name}")
    ax.set_xticks(xticks)
    ax.set_xticklabels(xticklabels)
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel)

# ===================
# Part 4: Saving Output
# ===================
# Improve spacing between subplots
plt.tight_layout()

plt.savefig("violin_47.pdf", bbox_inches="tight")
