# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(2)
# New data representing customer satisfaction scores for different sales channels
data_Website = np.random.normal(0.75, 0.08, 200)
data_RetailStore = np.random.normal(0.60, 0.10, 200)
data_CallCenter = np.random.normal(0.70, 0.09, 200)

xticklabels = ["Website", "Retail Store", "Call Center"]
ylabel = "Customer Satisfaction Scores"
title = "Customer Satisfaction Across Sales Channels"
ylim = [0.3, 1.0]
xticks = [1, 2, 3]
legends = ["Website", "Retail Store", "Call Center"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(8, 6))

# Create violin plots with transparency
violin_parts1 = ax.violinplot(data_Website, positions=[1], showmeans=True)
violin_parts2 = ax.violinplot(data_RetailStore, positions=[2], showmeans=True)
violin_parts3 = ax.violinplot(data_CallCenter, positions=[3], showmeans=True)

# Customize colors
violin_parts1["bodies"][0].set_facecolor("#8c564b")
violin_parts1["bodies"][0].set_alpha(0.6)

violin_parts2["bodies"][0].set_facecolor("#2ca02c")
violin_parts2["bodies"][0].set_alpha(0.6)

violin_parts3["bodies"][0].set_facecolor("#ff7f0e")
violin_parts3["bodies"][0].set_alpha(0.6)

# Customize mean line colors
for partname in ("cmeans", "cmaxes", "cmins", "cbars"):
    vp = violin_parts1[partname]
    vp.set_edgecolor("#1f77b4")  # Blue
    vp.set_linewidth(1.5)

    vp = violin_parts2[partname]
    vp.set_edgecolor("#1f77b4")  # Blue
    vp.set_linewidth(1.5)

    vp = violin_parts3[partname]
    vp.set_edgecolor("#1f77b4")  # Blue
    vp.set_linewidth(1.5)

# Set x-axis and y-axis labels
ax.set_xticks(xticks)
ax.set_xticklabels(xticklabels)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Add grid lines for better readability
ax.grid(True, linestyle="--", alpha=0.6)

# Set y-axis limits
ax.set_ylim(ylim)

# Add legend for clarity
plt.legend(legends, loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("violin_70.pdf", bbox_inches="tight")
