# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# New data representing student satisfaction scores for different types of schools
data_PublicSchools = np.random.normal(0.60, 0.10, 200)
data_PrivateSchools = np.random.normal(0.75, 0.08, 200)
data_CharterSchools = np.random.normal(0.70, 0.09, 200)

xticklabels = ["Public Schools", "Private Schools", "Charter Schools"]
ylabel = "Student Satisfaction Scores"
title = "Student Satisfaction Across Different Types of Schools"
ylim = [0.3, 1.0]
xticks = [1, 2, 3]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(8, 6))

# Create violin plots with transparency
violin_parts1 = ax.violinplot(data_PublicSchools, positions=[1], showmeans=True)
violin_parts2 = ax.violinplot(data_PrivateSchools, positions=[2], showmeans=True)
violin_parts3 = ax.violinplot(data_CharterSchools, positions=[3], showmeans=True)

# Customize colors
violin_parts1["bodies"][0].set_facecolor("#1f77b4")  # Blue
violin_parts1["bodies"][0].set_alpha(0.7)

violin_parts2["bodies"][0].set_facecolor("#2ca02c")  # Green
violin_parts2["bodies"][0].set_alpha(0.7)

violin_parts3["bodies"][0].set_facecolor("#9467bd")  # Purple
violin_parts3["bodies"][0].set_alpha(0.7)

# Customize mean line colors
for partname in ("cmeans", "cmaxes", "cmins", "cbars"):
    vp = violin_parts1[partname]
    vp.set_edgecolor("#ff7f0e")  # Orange
    vp.set_linewidth(1.5)

    vp = violin_parts2[partname]
    vp.set_edgecolor("#ff7f0e")  # Orange
    vp.set_linewidth(1.5)

    vp = violin_parts3[partname]
    vp.set_edgecolor("#ff7f0e")  # Orange
    vp.set_linewidth(1.5)

# Set x-axis and y-axis labels
ax.set_xticks(xticks)
ax.set_xticklabels(xticklabels)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Add grid lines for better readability
ax.grid(True, linestyle="--", alpha=0.6)

# Set y-axis limits
ax.set_ylim(ylim)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("violin_71.pdf", bbox_inches="tight")
