
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Generate new data for body posture analysis (sports domain)
# data for the first posture
posture1 = np.array(
    [
        np.linspace(0, 1, 17),  # Time in seconds
        np.random.uniform(0.2, 1.0, 17),  # Horizontal Displacement in meters
        np.random.uniform(0.1, 1.2, 17)  # Vertical Displacement in meters
    ]
)

# data for the second posture
posture2 = np.array(
    [
        np.linspace(0, 1, 17),  # Time in seconds
        np.random.uniform(0.3, 1.1, 17),  # Horizontal Displacement in meters
        np.random.uniform(0.2, 1.3, 17)  # Vertical Displacement in meters
    ]
)

labels = ["Phase 1", "Phase 2"]
xlabel = "Time (s)"
ylabel = "Horizontal Displacement (m)"
zlabel = "Vertical Displacement (m)"
title = "3D Athlete Movement Analysis"
legendlabels = ["Phase 1", "Phase 2"]
legendtitle="Phases"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# data for the first posture
x1 = posture1[0]
y1 = posture1[1]
z1 = posture1[2]

# data for the second posture
x2 = posture2[0]
y2 = posture2[1]
z2 = posture2[2]

fig, ax = plt.subplots(figsize=(10, 10), subplot_kw={"projection": "3d"})

radius = 1
ax.set_xlim3d([0, radius])
ax.set_ylim3d([0, radius])
ax.set_zlim3d([0, radius * 1.5])
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_zlabel(zlabel)
ax.set_title(title)
ax.view_init(elev=20.0, azim=40)
ax.dist = 8

color1 = "mediumseagreen"
color2 = "mediumslateblue"

# 3D scatter for first posture
ax.scatter3D(x1, y1, z1, color=color1, label=labels[0], s=50)

# draw the body for first posture
# left leg
ax.plot(x1[0:4], y1[0:4], z1[0:4], ls="--", color=color1, linewidth=2)
# right leg
ax.plot(
    np.hstack((x1[0], x1[4:7])),
    np.hstack((y1[0], y1[4:7])),
    np.hstack((z1[0], z1[4:7])),
    ls="--",
    color=color1,
    linewidth=2,
)
# spine
ax.plot(
    np.hstack((x1[0], x1[7:11])),
    np.hstack((y1[0], y1[7:11])),
    np.hstack((z1[0], z1[7:11])),
    ls="--",
    color=color1,
    linewidth=2,
)
# right arm
ax.plot(
    np.hstack((x1[8], x1[11:14])),
    np.hstack((y1[8], y1[11:14])),
    np.hstack((z1[8], z1[11:14])),
    ls="--",
    color=color1,
    linewidth=2,
)
# left arm
ax.plot(
    np.hstack((x1[8], x1[14:])),
    np.hstack((y1[8], y1[14:])),
    np.hstack((z1[8], z1[14:])),
    ls="--",
    color=color1,
    linewidth=2,
)

# 3D scatter for second posture
ax.scatter3D(x2, y2, z2, color=color2, label=labels[1], s=50)

# draw the body for second posture
# left leg
ax.plot(x2[0:4], y2[0:4], z2[0:4], ls="--", color=color2, linewidth=2)
# right leg
ax.plot(
    np.hstack((x2[0], x2[4:7])),
    np.hstack((y2[0], y2[4:7])),
    np.hstack((z2[0], z2[4:7])),
    ls="--",
    color=color2,
    linewidth=2,
)
# spine
ax.plot(
    np.hstack((x2[0], x2[7:11])),
    np.hstack((y2[0], y2[7:11])),
    np.hstack((z2[0], z2[7:11])),
    ls="--",
    color=color2,
    linewidth=2,
)
# right arm
ax.plot(
    np.hstack((x2[8], x2[11:14])),
    np.hstack((y2[8], y2[11:14])),
    np.hstack((z2[8], z2[11:14])),
    ls="--",
    color=color2,
    linewidth=2,
)
# left arm
ax.plot(
    np.hstack((x2[8], x2[14:])),
    np.hstack((y2[8], y2[14:])),
    np.hstack((z2[8], z2[14:])),
    ls="--",
    color=color2,
    linewidth=2,
)

plt.legend(title=legendtitle)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_21.pdf", bbox_inches="tight")
