

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(23)
# raw data
# data representing positions of weather stations and irrigation systems in a farm
weather_stations = np.array(
    [
        [10, 20, 25, 35, 40, 45, 55, 50, 44, 35, 30, 25, 15, 10, 15, 25, 35],
        [5, 15, 10, 25, 40, 35, 45, 40, 35, 25, 20, 10, 5, 0, 10, 20, 30],
        [3, 5, 4, 15, 10, 7, 12, 10, 7, 5, 7, 15, 5, 3, 10, 7, 5],
    ]
)

irrigation_systems = np.array(
    [
        [60, 55, 52, 65, 70, 65, 68, 70, 65, 52, 58, 73, 78, 75, 55, 45, 52],
        [25, 35, 30, 45, 60, 55, 65, 60, 55, 45, 40, 30, 25, 20, 40, 50, 45],
        [5, 7, 6, 8, 12, 9, 10, 15, 18, 20, 22, 18, 16, 14, 20, 18, 16],
    ]
)

labels = ["Weather Stations", "Irrigation Systems"]
xlabel = "X-Axis (Farm Position)"
ylabel = "Y-Axis (Farm Position)"
zlabel = "Z-Axis (Height/Depth)"
title = "3D Positioning of Farm Infrastructure"
legendlabels = ["Weather Stations", "Irrigation Systems"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Colors
color_weather_stations = "#1f77b4"
color_irrigation_systems = "#ff7f0e"

# data for the first component group (Weather Stations)
x1 = weather_stations[0]
y1 = weather_stations[1]
z1 = weather_stations[2]

# data for the second component group (Irrigation Systems)
x2 = irrigation_systems[0]
y2 = irrigation_systems[1]
z2 = irrigation_systems[2]

fig, ax = plt.subplots(figsize=(10, 10), subplot_kw={"projection": "3d"})

radius = 80
ax.set_xlim3d([0, radius])
ax.set_ylim3d([0, radius])
ax.set_zlim3d([0, 25])
ax.set_title(title, fontsize=16)
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_zlabel(zlabel, fontsize=12)
ax.view_init(elev=25.0, azim=60)
ax.dist = 7

# 3D scatter
ax.scatter3D(x1, y1, z1, color=color_weather_stations, label=labels[0], marker='o', s=100, alpha=0.7)
ax.scatter3D(x2, y2, z2, color=color_irrigation_systems, label=labels[1], marker='^', s=100, alpha=0.7)

# draw lines for components
# Weather Stations lines
ax.plot(x1[:5], y1[:5], z1[:5], ls="--", color=color_weather_stations, linewidth=2)
ax.plot(x1[5:], y1[5:], z1[5:], ls=":", color=color_weather_stations, linewidth=2)

# Irrigation Systems lines
ax.plot(x2[:5], y2[:5], z2[:5], ls="--", color=color_irrigation_systems, linewidth=2)
ax.plot(x2[5:], y2[5:], z2[5:], ls=":", color=color_irrigation_systems, linewidth=2)

plt.legend(legendlabels, fontsize=12, loc='upper left')

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_23.pdf", bbox_inches="tight")

