

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Hypothetical weather data functions
def temperature_trend(x, y):
    return 15 + 10 * np.sin(2 * np.pi * x) * np.cos(np.pi * y)

def humidity_trend(x, y):
    return 50 + 30 * np.cos(2 * np.pi * x) * np.sin(np.pi * y)

# Create a grid of points representing time and varying conditions
x = np.linspace(0, 1, 100)
y = np.linspace(0, 1, 100)
x, y = np.meshgrid(x, y)
z1 = temperature_trend(x, y)
z2 = humidity_trend(x, y)

# Axes Limits and Labels
ax1_title = "Temperature Trends"
ax2_title = "Humidity Trends"
xlabel = "Time (Fraction of Year)"
ylabel = "Measurement"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure with specified size
fig = plt.figure(figsize=(12, 6))

# Axis limit values
xlim_values = np.linspace(0, 1, 9)
ylim_values = np.linspace(0, 1, 9)

# First subplot
ax1 = fig.add_subplot(121, projection="3d")
ax1.plot_surface(x, y, z1, cmap="plasma", edgecolor='none')
ax1.set_title(ax1_title)
ax1.set_xlabel(xlabel,labelpad=10)
ax1.set_ylabel(ylabel,labelpad=10)
ax1.set_xticks(xlim_values)
ax1.set_xticklabels(xlim_values, rotation=45)
ax1.set_yticks(ylim_values)
ax1.set_yticklabels(ylim_values, rotation=0)

# Second subplot
ax2 = fig.add_subplot(122, projection="3d")
ax2.plot_surface(x, y, z2, cmap="viridis", edgecolor='none')
ax2.set_title(ax2_title)
ax2.set_xlabel(xlabel,labelpad=10)
ax2.set_ylabel(ylabel,labelpad=10)
ax2.set_xticks(xlim_values)
ax2.set_xticklabels(xlim_values, rotation=45)
ax2.set_yticks(ylim_values)
ax2.set_yticklabels(ylim_values, rotation=0)
ax1.set_box_aspect(aspect=None, zoom=0.9)
ax2.set_box_aspect(aspect=None, zoom=0.9)
# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure

plt.tight_layout()
plt.savefig("3d_25.pdf", bbox_inches="tight")

