

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from mpl_toolkits.mplot3d import Axes3D

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Define the Gaussian function
def gaussian(x, y, sigma=0.1, mu=0):
    return np.exp(-((x - mu) ** 2 + (y - mu) ** 2) / (2.0 * sigma**2))

# Simulate data for "Temperature Anomaly" and "CO2 Emissions"
years = np.linspace(0, 10, 100)  # 10 years
years_x, years_y = np.meshgrid(years, years)

temperature_anomaly = 2 * gaussian(years_x, years_y, sigma=2, mu=5)
co2_emissions = 400 * gaussian(years_x, years_y, sigma=1.5, mu=5)

# Axes Limits and Labels
ax1_title = "Temperature Anomaly Over Time"
ax2_title = "CO2 Emissions Over Time"
xlabel = "Time (Years)"
ylabel1 = "Temperature Anomaly (°C)"
ylabel2 = "CO2 Emissions (ppm)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure with specified size
fig = plt.figure(figsize=(12, 8))

xlim_values = np.linspace(0, 10, 11)
ylim_values = np.linspace(0, 10, 11)
cmap1 = "Reds"
cmap2 = "Purples"

# First subplot
ax1 = fig.add_subplot(121, projection="3d")
ax1.plot_surface(years_x, years_y, temperature_anomaly, cmap=cmap1, edgecolor='w')
ax1.set_title(ax1_title, fontsize=15, fontweight='bold')
ax1.set_xlabel(xlabel, fontsize=12,labelpad=10)
ax1.set_ylabel(xlabel, fontsize=12,labelpad=10)
ax1.set_zlabel(ylabel1, fontsize=12)
ax1.set_xticks(xlim_values)
ax1.set_xticklabels([f"{xt:.1f}" for xt in xlim_values], rotation=45)
ax1.set_yticks(ylim_values)
ax1.set_yticklabels([f"{yt:.1f}" for yt in ylim_values], rotation=0)

# Second subplot
ax2 = fig.add_subplot(122, projection="3d")
ax2.plot_surface(years_x, years_y, co2_emissions, cmap=cmap2, edgecolor='w')
ax2.set_title(ax2_title, fontsize=15, fontweight='bold')
ax2.set_xlabel(xlabel, fontsize=12,labelpad=10)
ax2.set_ylabel(xlabel, fontsize=12,labelpad=10)
ax2.set_zlabel(ylabel2, fontsize=12)
ax2.set_xticks(xlim_values)
ax2.set_xticklabels([f"{xt:.1f}" for xt in xlim_values], rotation=45)
ax2.set_yticks(ylim_values)
ax2.set_yticklabels([f"{yt:.1f}" for yt in ylim_values], rotation=0)
ax1.set_box_aspect(aspect=(0.9, 1.2, 1), zoom=0.9)
ax2.set_box_aspect(aspect=(0.9, 1.2, 1), zoom=0.9)
# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("3d_26.pdf", bbox_inches="tight")

