

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
import numpy as np

np.random.seed(42)

years = np.array(
    [
        [2000, 2005, 2010, 2015, 2020, 2025],
        [2000, 2005, 2010, 2015, 2020, 2025],
        [2000, 2005, 2010, 2015, 2020, 2025],
        [2000, 2005, 2010, 2015, 2020, 2025],
        [2000, 2005, 2010, 2015, 2020, 2025],
        [2000, 2005, 2010, 2015, 2020, 2025],
    ]
)
carbon_emissions = np.array(
    [
        [6, 6.5, 7, 7.5, 8, 8.5],
        [12, 12.5, 13, 13.5, 14, 14.5],
        [18, 18.5, 19, 19.5, 20, 20.5],
        [24, 24.5, 25, 25.5, 26, 26.5],
        [30, 30.5, 31, 31.5, 32, 32.5],
        [36, 36.5, 37, 37.5, 38, 38.5],
    ]
)
global_temperatures = np.array(
    [
        [14, 14.1, 14.2, 14.3, 14.4, 14.5],
        [14.2, 14.3, 14.4, 14.5, 14.6, 14.7],
        [14.4, 14.5, 14.6, 14.7, 14.8, 14.9],
        [14.6, 14.7, 14.8, 14.9, 15.0, 15.1],
        [14.8, 14.9, 15.0, 15.1, 15.2, 15.3],
        [15.0, 15.1, 15.2, 15.3, 15.4, 15.5],
    ]
)

xlabel = "Years"
ylabel = "Carbon Emissions (Metric Tons)"
zlabel = "Global Temperatures (°C)"
title = "Global Environmental Data Analysis"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig = plt.figure(figsize=(10, 6))  # Adjusting figure size to match original image's dimensions
ax = fig.add_subplot(111, projection="3d")

# Plot a 3D surface
surf = ax.plot_surface(years, carbon_emissions, global_temperatures, cmap="viridis", edgecolor="black")

# Labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_zlabel(zlabel)
ax.set_title(title, y=1.00)
ax.set_box_aspect(aspect=None, zoom=0.9)

# ===================
# Part 4: Saving Output
# ===================
# Saving the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("3d_27.pdf", bbox_inches="tight")
