
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate new energy data
time = np.linspace(0, 36, 200)  # Simulate time in months for 3 years
energy_consumption = np.cumsum(np.random.randn(200)) * 100 + 5000  # Simulate energy consumption
renewable_energy_share = np.clip(np.cumsum(np.random.randn(200)) * 0.01 + 0.5, 0, 1)  # Simulate renewable energy share
carbon_emission = np.cumsum(np.random.randn(200)) * 30 + 1000  # Simulate carbon emissions
energy_prices = np.cumsum(np.random.randn(200)) * 2 + 50  # Simulate energy prices

# Titles and labels for the new context
titles = ["Energy Consumption", "Renewable Energy Share", "Carbon Emission", "Energy Prices"]
xlabels = ["Time (months)", "Time (months)", "Time (months)", "Time (months)"]
ylabels = ["Consumption (MWh)", "Share (%)", "Emission (tons)", "Prices ($/MWh)"]
zlabels = ["Value", "Value", "Value", "Value"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with specified size to match the original image's dimensions
fig = plt.figure(figsize=(15, 10))
cmap = "coolwarm"

# Plot the first subplot - Energy Consumption
ax1 = fig.add_subplot(141, projection="3d", facecolor="white")
z1 = np.tile(energy_consumption, (200, 1))  # Create a surface by repeating the energy consumption
m, n = np.meshgrid(time, time)
surf1 = ax1.plot_surface(m, n, z1, cmap=cmap)
ax1.set_title(titles[0], fontsize=14, y=1.05)
ax1.set_xlabel(xlabels[0], fontsize=12)
ax1.set_ylabel(ylabels[0], fontsize=12)
ax1.set_zlabel(zlabels[0], fontsize=12)

# Plot the second subplot - Renewable Energy Share
ax2 = fig.add_subplot(142, projection="3d", facecolor="white")
z2 = np.tile(renewable_energy_share, (200, 1))
surf2 = ax2.plot_surface(m, n, z2, cmap=cmap)
ax2.set_title(titles[1], fontsize=14, y=1.05)
ax2.set_xlabel(xlabels[1], fontsize=12)
ax2.set_ylabel(ylabels[1], fontsize=12)
ax2.set_zlabel(zlabels[1], fontsize=12)

# Plot the third subplot - Carbon Emission
ax3 = fig.add_subplot(143, projection="3d", facecolor="white")
z3 = np.tile(carbon_emission, (200, 1))
surf3 = ax3.plot_surface(m, n, z3, cmap=cmap)
ax3.set_title(titles[2], fontsize=14, y=1.05)
ax3.set_xlabel(xlabels[2], fontsize=12)
ax3.set_ylabel(ylabels[2], fontsize=12)
ax3.set_zlabel(zlabels[2], fontsize=12)

# Plot the fourth subplot - Energy Prices
ax4 = fig.add_subplot(144, projection="3d", facecolor="white")
z4 = np.tile(energy_prices, (200, 1))
surf4 = ax4.plot_surface(m, n, z4, cmap=cmap)
ax4.set_title(titles[3], fontsize=14, y=1.05)
ax4.set_xlabel(xlabels[3], fontsize=12)
ax4.set_ylabel(ylabels[3], fontsize=12)
ax4.set_zlabel(zlabels[3], fontsize=12)

# Adjust layout and spacing
plt.tight_layout()

# ===================
# Part 4: Saving Output
# ===================
# Show the plot
plt.savefig("3d_31.pdf", bbox_inches="tight")
