

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Define the synthetic real estate data
latitude = np.linspace(-90, 90, 200)
longitude = np.linspace(-180, 180, 200)
latitude, longitude = np.meshgrid(latitude, longitude)

property_price = 300000 + 100000 * np.sin(np.deg2rad(latitude)) * np.cos(np.deg2rad(longitude)) + 50000 * np.random.rand(200, 200)
construction_activity = 20 + 30 * np.sin(np.deg2rad(latitude)) * np.cos(np.deg2rad(longitude)) + 10 * np.random.rand(200, 200)
population_density = 1000 + 4000 * np.sin(np.deg2rad(latitude)) * np.sin(np.deg2rad(longitude)) + 500 * np.random.rand(200, 200)
crime_rate = 50 + 20 * np.cos(np.deg2rad(latitude)) * np.sin(np.deg2rad(longitude)) + 10 * np.random.rand(200, 200)

titles = ["Property Price Distribution", "Construction Activity Distribution", "Population Density Distribution", "Crime Rate Distribution"]
xlabels = ["Longitude", "Longitude", "Longitude", "Longitude"]
ylabels = ["Latitude", "Latitude", "Latitude", "Latitude"]
zlabels = ["Property Price ($)", "Construction Activity (%)", "Population Density (people/km²)", "Crime Rate (incidents/1000 people)"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(15, 10))

# Plot the first subplot - Property Price Distribution
ax1 = fig.add_subplot(141, projection="3d", facecolor="white")
surf1 = ax1.plot_surface(longitude, latitude, property_price, cmap="hot")
ax1.set_title(titles[0], fontsize=14, y=-0.1)
ax1.set_xlabel(xlabels[0], fontsize=12)
ax1.set_ylabel(ylabels[0], fontsize=12)
ax1.set_zlabel(zlabels[0], fontsize=12)

# Plot the second subplot - Construction Activity Distribution
ax2 = fig.add_subplot(142, projection="3d", facecolor="white")
surf2 = ax2.plot_surface(longitude, latitude, construction_activity, cmap="Blues")
ax2.set_title(titles[1], fontsize=14, y=-0.1)
ax2.set_xlabel(xlabels[1], fontsize=12)
ax2.set_ylabel(ylabels[1], fontsize=12)
ax2.set_zlabel(zlabels[1], fontsize=12)

# Plot the third subplot - Population Density Distribution
ax3 = fig.add_subplot(143, projection="3d", facecolor="white")
surf3 = ax3.plot_surface(longitude, latitude, population_density, cmap="Greens")
ax3.set_title(titles[2], fontsize=14, y=-0.1)
ax3.set_xlabel(xlabels[2], fontsize=12)
ax3.set_ylabel(ylabels[2], fontsize=12)
ax3.set_zlabel(zlabels[2], fontsize=12)

# Plot the fourth subplot - Crime Rate Distribution
ax4 = fig.add_subplot(144, projection="3d", facecolor="white")
surf4 = ax4.plot_surface(longitude, latitude, crime_rate, cmap="Greys")
ax4.set_title(titles[3], fontsize=14, y=-0.1)
ax4.set_xlabel(xlabels[3], fontsize=12)
ax4.set_ylabel(ylabels[3], fontsize=12)
ax4.set_zlabel(zlabels[3], fontsize=12)

# Adjust layout and spacing
plt.tight_layout()

# Show the plot
plt.savefig("3d_32.pdf", bbox_inches="tight")

