

# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data
import numpy as np

np.random.seed(0)
likes = np.random.uniform(100, 1000, 17)  # Simulated Likes data
comments = np.random.uniform(10, 100, 17)  # Simulated Comments data
shares = np.random.uniform(1, 50, 17)  # Simulated Shares data
label = "Engagement Metrics"

# Label texts for the chart
xlabel = "Likes"
ylabel = "Comments"
zlabel = "Shares"
title = "3D Scatter Plot of Social Media Engagement"
legendlabel = "Engagement Metrics"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(7, 7), subplot_kw={"projection": "3d"})

# Axis limits
ax.set_xlim3d([100, 1000])
ax.set_ylim3d([10, 100])
ax.set_zlim3d([1, 50])
ax.view_init(elev=15.0, azim=120)
ax.dist = 10

# 3D scatter plot
ax.scatter3D(likes, comments, shares, color="forestgreen", label=label, marker="o", s=70)

# Connecting data points (example for trends)
ax.plot(likes, comments, shares, ls="--", color="darkgreen", lw=1)

# Adding labels
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_zlabel(zlabel, fontsize=12)
ax.set_title(title, fontsize=14)

# Add legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_33.pdf", bbox_inches="tight")

