
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# New weather simulation data
xp = np.linspace(0, 24, 17)  # Time in hours over a day
yp = 20 + 5 * np.sin(xp * np.pi / 12) + np.random.uniform(-2, 2, 17)  # Temperature variations in degrees Celsius
zp = np.cumsum(np.random.uniform(-5, 5, 17)) + 50  # Cumulative humidity percentage starting around 50%

label = "Weather Data"
xlabel = "Time (Hours)"
ylabel = "Temperature (°C)"
zlabel = "Humidity (%)"
title = "Weather Simulation 3D Scatter Plot"
legend_label = "Weather Data"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 10), subplot_kw={"projection": "3d"})

radius = 25
ax.set_xlim3d([0, 24])
ax.set_ylim3d([min(yp) - 5, max(yp) + 5])
ax.set_zlim3d([min(zp) - 5, max(zp) + 5])
ax.view_init(elev=20.0, azim=60)
ax.dist = 10

# 3D scatter
ax.scatter3D(xp, yp, zp, color="dodgerblue", label=label, marker='o', s=100)

# draw the figure with different colors and line styles
# left leg
ax.plot(xp[0:4], yp[0:4], zp[0:4], ls="--", color="blue", linewidth=2)
# right leg
ax.plot(np.hstack((xp[0], xp[4:7])), np.hstack((yp[0], yp[4:7])), np.hstack((zp[0], zp[4:7])), ls="--", color="green", linewidth=2)
# spine
ax.plot(np.hstack((xp[0], xp[7:11])), np.hstack((yp[0], yp[7:11])), np.hstack((zp[0], zp[7:11])), ls="-.", color="purple", linewidth=2)
# right arm
ax.plot(np.hstack((xp[8], xp[11:14])), np.hstack((yp[8], yp[11:14])), np.hstack((zp[8], zp[11:14])), ls=":", color="red", linewidth=2)
# left arm
ax.plot(np.hstack((xp[8], xp[14:])), np.hstack((yp[8], yp[14:])), np.hstack((zp[8], zp[14:])), ls="-", color="orange", linewidth=2)

ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_zlabel(zlabel)
ax.set_title(title)
plt.legend([legend_label], loc='upper left')

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_34.pdf", bbox_inches="tight")
