

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Fictional financial data: number of investment products sold (in thousands) in four different regions
hist = np.array(
    [
        [25.0, 28.0, 30.0, 22.0],  # Product A
        [20.0, 18.0, 15.0, 17.0],  # Product B
        [30.0, 25.0, 27.0, 23.0],  # Product C
        [18.0, 15.0, 10.0, 12.0],  # Product D
    ]
)

xedges = np.array([0.0, 1.0, 2.0, 3.0, 4.0])  # Region edges
yedges = np.array([0.0, 1.0, 2.0, 3.0, 4.0])  # Product edges

xlabel = 'Regions'
ylabel = 'Investment Products'
title = 'Distribution of Investment Products Sold Across Regions'
legend_labels = ['Product A', 'Product B', 'Product C', 'Product D']

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Construct arrays for the anchor positions of the 16 bars.
xpos, ypos = np.meshgrid(xedges[:-1] + 0.5, yedges[:-1] + 0.5, indexing="ij")
xpos = xpos.ravel()
ypos = ypos.ravel()
zpos = 0

# Construct arrays with the dimensions for the 16 bars.
dx = dy = 0.8 * np.ones_like(zpos)
dz = hist.ravel()

fig = plt.figure(figsize=(10, 8))
ax = fig.add_subplot(projection="3d")

# Create a colormap for the color bar
colors = plt.cm.Pastel1(dz / dz.max())
bar3d = ax.bar3d(xpos, ypos, zpos, dx, dy, dz, zsort="average", color=colors, edgecolor='k', alpha=0.7)

# Add color bar which maps values to colors.
sm = plt.cm.ScalarMappable(
    cmap=plt.cm.Pastel1, norm=plt.Normalize(vmin=dz.min(), vmax=dz.max())
)
sm.set_array([])
fig.colorbar(sm, ax=ax, shrink=0.5, aspect=10)  # Adjust colorbar position and size

# Setting labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_zlabel('Sales (thousands)')
ax.set_title(title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_41.pdf", bbox_inches="tight")

