
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Political data
party_A = np.array(
    [
        np.random.uniform(40, 60, 10),  # Approval Rating (%)
        np.random.uniform(10, 50, 10),  # Campaign Funding (in millions)
        np.random.uniform(100, 500, 10),  # Number of Volunteers
    ]
)
party_B = np.array(
    [
        np.random.uniform(35, 55, 10),  # Approval Rating (%)
        np.random.uniform(15, 55, 10),  # Campaign Funding (in millions)
        np.random.uniform(150, 550, 10),  # Number of Volunteers
    ]
)
party_C = np.array(
    [
        np.random.uniform(30, 50, 10),  # Approval Rating (%)
        np.random.uniform(20, 60, 10),  # Campaign Funding (in millions)
        np.random.uniform(200, 600, 10),  # Number of Volunteers
    ]
)

xlabel = "Approval Rating (%)"
ylabel = "Campaign Funding (millions)"
zlabel = "Number of Volunteers"
title = "Comparison of Political Parties"
legendlabels = ["Party A", "Party B", "Party C"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(10, 8))
ax = fig.add_subplot(projection="3d")

ax.scatter(party_A[0], party_A[1], party_A[2], marker="o", color="teal", s=50, label=legendlabels[0], depthshade=False)
ax.scatter(party_B[0], party_B[1], party_B[2], marker="^", color="magenta", s=50, label=legendlabels[1], depthshade=False)
ax.scatter(party_C[0], party_C[1], party_C[2], marker="s", color="darkorange", s=50, label=legendlabels[2], depthshade=False)

ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_zlabel(zlabel)
ax.set_title(title)
ax.legend()

ax.set_xticks([30, 35, 40, 45, 50, 55, 60])
ax.set_yticks([10, 20, 30, 40, 50, 60])
ax.set_zticks([100, 200, 300, 400, 500, 600])

ax.set_box_aspect(aspect=None, zoom=0.9)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_44.pdf", bbox_inches="tight")

