
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
solar = np.array([[15.0, 20.0, 25.0], [1500.0, 3000.0, 4500.0], [0.10, 0.09, 0.08]])
wind = np.array([[20.0, 25.0, 30.0], [3000.0, 6000.0, 9000.0], [0.08, 0.07, 0.06]])
nuclear = np.array([[50.0, 45.0, 40.0], [5000.0, 8000.0, 10000.0], [0.15, 0.14, 0.13]])
xlabel = "Efficiency (%)"
ylabel = "Production (kWh)"
zlabel = "Cost (USD per kWh)"
title = "3D Visualization of Energy Source Attributes"
legend_labels = ["Solar", "Wind", "Nuclear"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(10, 8))
ax = fig.add_subplot(projection="3d")

# Plotting the data with enhanced styles
ax.plot(solar[0], solar[1], solar[2], color="#5b5fc7", linestyle='--', linewidth=2, marker='o', markersize=6, label=legend_labels[0])
ax.plot(wind[0], wind[1], wind[2], color="#76c043", linestyle='-.', linewidth=2, marker='s', markersize=6, label=legend_labels[1])
ax.plot(nuclear[0], nuclear[1], nuclear[2], color="#c49820", linestyle=':', linewidth=2, marker='^', markersize=6, label=legend_labels[2])

# Setting axis labels and title
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_zlabel(zlabel, fontsize=12)
ax.set_title(title, fontsize=15, pad=20)

# Customizing ticks
ax.set_xticks([10, 20, 30, 40, 50])
ax.set_yticks([1000, 3000, 5000, 7000, 10000])
ax.set_zticks([0.05, 0.08, 0.11, 0.14, 0.17])

# Adding legend
ax.legend(loc='upper left', fontsize=10)

# Improving the aspect ratio
ax.set_box_aspect([1.5, 1.5, 1.5])  # [x, y, z]

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_47.pdf", bbox_inches="tight")
