

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Define text label parameters
xlabel = 'Longitude'
ylabel = 'Latitude'
zlabel = 'Population'
title = 'Historical Population Distribution Over Time and Geography'

# Generate data for historical population distribution
lon = np.linspace(-180, 180, 100)  # Longitude from -180 to 180 degrees
lat = np.linspace(-90, 90, 100)    # Latitude from -90 to 90 degrees
lon, lat = np.meshgrid(lon, lat)
# Population function, can be adjusted for more realism
population = 10**6 * (1 + np.sin(np.deg2rad(lat)) * np.cos(np.deg2rad(lon)))

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(10, 8))
ax = fig.add_subplot(projection="3d")

# Define color map
cmap = "plasma"

# Plot the surface
ax.plot_surface(lon, lat, population, cmap=cmap, edgecolor="k", alpha=0.7)

# Set an equal aspect ratio
ax.set_aspect("auto")

# Setting labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_zlabel(zlabel)
ax.set_title(title)
ax.set_box_aspect([1,1,1])
# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("3d_53.pdf", bbox_inches="tight")

