
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Generate new data based on economics domain (GDP growth over time)
np.random.seed(0)
x = np.linspace(2000, 2020, 9)  # Years from 2000 to 2020
y = np.array([1, 2, 3, 4, 5, 6, 7, 8, 9])  # Placeholder for different regions
z = np.array([2.5, 3.1, 3.7, 2.9, 3.8, 4.2, 3.5, 3.9, 4.4])  # Example GDP growth percentages with slight variation
z_fit = np.poly1d(np.polyfit(x, z, 1))(x)  # Linear fit for trend

# Text labels and title
xlabel = "Year"
ylabel = "Region"
zlabel = "GDP Growth (%)"
title = "GDP Growth Over Time Across Regions"
labels = ["Actual Growth", "Trend Line"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(10, 8))
ax = fig.add_subplot(111, projection="3d")

# Scatter plot for actual data points
ax.scatter(x, y, z, color="#D62728", label=labels[0], marker="^", s=100)

# Line plot for trend line
ax.plot(x, y, z_fit, color="#1F77B4", label=labels[1], linestyle="--", linewidth=2)

# Setting axes labels and title
ax.set_xlabel(xlabel, fontsize=12, labelpad=10)
ax.set_ylabel(ylabel, fontsize=12, labelpad=10)
ax.set_zlabel(zlabel, fontsize=12, labelpad=10)
ax.set_title(title, fontsize=14)
ax.legend()

# Adjust box aspect ratio and zoom level for better visualization
ax.set_box_aspect(aspect=(1.5, 1, 1.5), zoom=0.9)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_55.pdf", bbox_inches="tight")
