
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
yticklabels = ["North America", "Asia"]
years = np.array([2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019])
north_america = np.array([200, 220, 240, 260, 280, 300, 320, 340, 360, 380])
asia = np.array([150, 170, 200, 230, 270, 310, 360, 410, 460, 520])
xlabel = "Year"
ylabel = "Region"
zlabel = "Number of Smartphone Users (in millions)"
title = "Number of Smartphone Users in Different Regions (2010-2019)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(10, 7))
ax = fig.add_subplot(projection="3d")

ax.bar(years, north_america, zs=0, zdir="y", color="lightcoral", alpha=0.85, edgecolor='darkred')
ax.bar(years, asia, zs=1, zdir="y", color="lightseagreen", alpha=0.85, edgecolor='darkgreen')

ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_zlabel(zlabel, fontsize=12)

ax.set_yticks([0, 1])
ax.set_yticklabels(yticklabels)

plt.title(title, pad=20, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_57.pdf", bbox_inches="tight")
