
# ===================
# Part 1: Importing Libraries
# ===================
import math
import matplotlib.pyplot as plt

from matplotlib.collections import PolyCollection

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Fixing random state for reproducibility
def polygon_under_graph(x, y):
    """
    Construct the vertex list which defines the polygon filling the space under
    the (x, y) line graph. This assumes x is in ascending order.
    """
    return [(x[0], 0.0), *zip(x, y), (x[-1], 0.0)]

x = np.linspace(10, 70, 41)
activity_numbers = range(1, 4)

# Example data: average monthly internet usage for different online activities
def activity_data(v, x):
    return 12 * np.sin(v * x / 50.0) + 20

# verts[i] is a list of (x, y) pairs defining polygon i.
verts = [
    polygon_under_graph(x, activity_data(v, x))
    for v in activity_numbers
]

xlabel = "Age Group (years)"
ylabel = "Activity Type"
zlabel = "Average Monthly Usage (hours)"
title="Average Monthly Internet Usage Across Age Groups"
# Adjust labels
activities = ['Social Media', 'Streaming Services', 'Online Gaming']

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
ax = plt.figure(figsize=(10, 8)).add_subplot(projection="3d")
facecolors = ['#8c564b', '#e377c2', '#7f7f7f']

poly = PolyCollection(verts, facecolors=facecolors, alpha=0.8)
ax.add_collection3d(poly, zs=activity_numbers, zdir="y")

ax.set(
    xlim=(10, 70),
    ylim=(1, 4),
    zlim=(0, 45),
    xlabel=xlabel,
    zlabel=zlabel,
)
ax.set_ylabel(ylabel, rotation=0, labelpad=30)

# Set y-axis ticks to activity names
ax.set_yticks(activity_numbers)
ax.set_yticklabels(activities)
ax.set_box_aspect(aspect=(1,1.2,1.2), zoom=1)
ax.tick_params(axis='y', pad=-5)
# Title and annotations
plt.title(title, pad=10)
ax.text(65, 3.5, 42, "Higher usage", style='italic', fontsize=10, color='gray')
ax.text(65, 3.5, 2, "Lower usage", style='italic', fontsize=10, color='gray')

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_60.pdf", bbox_inches="tight")
