
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Generate data for tourism metrics (visitor count, average spending, duration of stay)
np.random.seed(42)

# Visitor Count data
visitor_count_set1 = np.random.poisson(lam=300, size=50)  # average count around 300 visitors
visitor_count_set2 = np.random.poisson(lam=350, size=50)  # average count around 350 visitors

# Average Spending data (USD)
spending_set1 = np.random.normal(loc=200, scale=50, size=50)  # mean spending around $200
spending_set2 = np.random.normal(loc=220, scale=40, size=50)  # mean spending around $220

# Duration of Stay data (days)
stay_duration_set1 = np.random.normal(loc=5, scale=1.5, size=50)  # mean duration around 5 days
stay_duration_set2 = np.random.normal(loc=6, scale=1.2, size=50)  # mean duration around 6 days

labels = ["Tourism Data Set 1", "Tourism Data Set 2"]
xlabel = "Visitor Count"
ylabel = "Average Spending (USD)"
zlabel = "Duration of Stay (Days)"
title = "Tourism Pattern Analysis"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 7), subplot_kw={"projection": "3d"})

# Configure the plot limits
ax.set_xlim3d([200, 400])
ax.set_ylim3d([100, 300])
ax.set_zlim3d([2, 10])

# Set the viewing angle
ax.view_init(elev=30, azim=45)
ax.dist = 10

# Scatter plot for the first set of data
ax.scatter3D(visitor_count_set1, spending_set1, stay_duration_set1, color="#1f77b4", marker="o", label=labels[0], edgecolor='k')

# Scatter plot for the second set of data
ax.scatter3D(visitor_count_set2, spending_set2, stay_duration_set2, color="#ff7f0e", marker="^", label=labels[1], edgecolor='k')

# Modify axis labels and title
ax.set_xlabel(xlabel, fontsize=12, labelpad=10)
ax.set_ylabel(ylabel, fontsize=12, labelpad=10)
ax.set_zlabel(zlabel, fontsize=12, labelpad=10)
ax.set_title(title, fontsize=15, pad=20)

# Legend for the plot
plt.legend(loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_66.pdf", bbox_inches="tight")
