

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Generate data for air pollutant concentrations (NO2, PM2.5, SO2)
np.random.seed(42)

# NO2 concentration data
no2_concentration = np.random.normal(
    loc=50, scale=20, size=50
)  # mean concentration around 50 µg/m³

# PM2.5 concentration data
pm25_concentration = np.random.uniform(
    low=10, high=50, size=50
)  # randomly between 10 and 50 µg/m³

# SO2 concentration data
so2_concentration = np.random.normal(
    loc=20, scale=10, size=50
)  # mean concentration around 20 µg/m³

# Second set of data for variations in different conditions
no2_concentration2 = np.random.normal(loc=55, scale=15, size=50)
pm25_concentration2 = np.random.uniform(low=15, high=45, size=50)
so2_concentration2 = np.random.normal(loc=22, scale=12, size=50)

labels = ["Pollution Set 1", "Pollution Set 2"]
xlabel = "NO2 Concentration (µg/m³)"
ylabel = "PM2.5 Concentration (µg/m³)"
zlabel = "SO2 Concentration (µg/m³)"
title = "3D Air Quality Patterns"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 7), subplot_kw={"projection": "3d"})

# Configure the plot limits
ax.set_xlim3d([0, 100])
ax.set_ylim3d([0, 60])
ax.set_zlim3d([0, 40])

# Set the viewing angle
ax.view_init(elev=25, azim=60)
ax.dist = 10

# Scatter plot for the first set of data
ax.scatter3D(no2_concentration, pm25_concentration, so2_concentration, color="#1f78b4", marker="o", label=labels[0])

# Scatter plot for the second set of data
ax.scatter3D(no2_concentration2, pm25_concentration2, so2_concentration2, color="#33a02c", marker="^", label=labels[1])

# Modify axis labels and title
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_zlabel(zlabel, fontsize=12)
ax.set_title(title, fontsize=15)

ax.set_box_aspect(aspect=[1, 1, 1], zoom=0.95)

# Legend for the plot
plt.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_67.pdf", bbox_inches="tight")

