

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting trends in philosophical ideas (simulating wave patterns)
import numpy as np

# Set a random seed for reproducibility
np.random.seed(42)
X = np.linspace(0, 2 * np.pi, 100)
Y = np.linspace(0, 2 * np.pi, 100)
X, Y = np.meshgrid(X, Y)
Z1 = np.sin(X) * np.sin(Y) + np.cos(X / 3)
Z2 = np.sin(X / 3) * np.sin(Y / 3) + np.sin(X)

# Titles and labels
title1 = "Trend in Philosophical Idea 1"
title2 = "Trend in Philosophical Idea 2"
xlabel = "Era"
ylabel = "Philosophical Attribute"
zlabel = "Popularity"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure with specified size
fig, axs = plt.subplots(1, 2, figsize=(14, 6), subplot_kw={"projection": "3d"})

# First subplot
axs[0].plot_surface(X, Y, Z1, cmap="viridis", edgecolor="none", alpha=0.85)
axs[0].set_title(title1)
axs[0].set_xlabel(xlabel)
axs[0].set_ylabel(ylabel)
axs[0].set_zlabel(zlabel)

# Second subplot
axs[1].plot_surface(X, Y, Z2, cmap="plasma", edgecolor="none", alpha=0.85)
axs[1].set_title(title2)
axs[1].set_xlabel(xlabel)
axs[1].set_ylabel(ylabel)
axs[1].set_zlabel(zlabel)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("3d_70.pdf", bbox_inches="tight")

