

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Set a random seed for reproducibility
import numpy as np
np.random.seed(0)

# Define the data for the agricultural metrics surface plots
x = np.linspace(-10, 10, 200)  # Increased resolution
y = np.linspace(-10, 10, 200)  # Increased resolution
x, y = np.meshgrid(x, y)
z1 = 0.5 * np.exp(-0.1 * (x**2 + y**2))  # Gaussian peak representing Soil Moisture Index
z2 = np.sin(x) * np.cos(y)  # A wave pattern representing Crop Yield Projection
z3 = 0.2 * np.log(x**2 + y**2 + 1) + 0.3 * np.sin(0.5 * x) * np.cos(0.5 * y)  # Combination for Fertilizer Effectiveness
z4 = 0.1 * (x**2 - y**2)  # Hyperbolic paraboloid representing Pest Infestation Risk

# Extracted text variables
title_soil_moisture = "Soil Moisture Index"
title_crop_yield = "Crop Yield Projection"
title_fertilizer_effectiveness = "Fertilizer Effectiveness"
title_pest_infestation = "Pest Infestation Risk"
x_label = "Field X Coordinate"
y_label = "Field Y Coordinate"
z_label_soil_moisture = "Moisture Level"
z_label_crop_yield = "Yield Level"
z_label_fertilizer = "Effectiveness Level"
z_label_pest = "Infestation Risk"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
font_size = 12
title_pad = 10

# Create a figure with specified size to match the original image's dimensions
fig = plt.figure(figsize=(14, 10))

# Plot the first subplot
ax1 = fig.add_subplot(141, projection="3d", facecolor="white")  # Set background to white
surf1 = ax1.plot_surface(x, y, z1, cmap="Blues", edgecolor='none')
ax1.set_title(title_soil_moisture, fontsize=font_size, pad=title_pad)
ax1.set_xlabel(x_label, fontsize=font_size)  # Increased font size
ax1.set_ylabel(y_label, fontsize=font_size)  # Increased font size
ax1.set_zlabel(z_label_soil_moisture, fontsize=font_size)  # Increased font size

# Plot the second subplot
ax2 = fig.add_subplot(142, projection="3d", facecolor="white")
surf2 = ax2.plot_surface(x, y, z2, cmap="coolwarm", edgecolor='none')
ax2.set_title(title_crop_yield, fontsize=font_size, pad=title_pad)
ax2.set_xlabel(x_label, fontsize=font_size)
ax2.set_ylabel(y_label, fontsize=font_size)
ax2.set_zlabel(z_label_crop_yield, fontsize=font_size)

# Plot the third subplot
ax3 = fig.add_subplot(143, projection="3d", facecolor="white")
surf3 = ax3.plot_surface(x, y, z3, cmap="viridis", edgecolor='none')
ax3.set_title(title_fertilizer_effectiveness, fontsize=font_size, pad=title_pad)
ax3.set_xlabel(x_label, fontsize=font_size)
ax3.set_ylabel(y_label, fontsize=font_size)
ax3.set_zlabel(z_label_fertilizer, fontsize=font_size)

# Plot the fourth subplot
ax4 = fig.add_subplot(144, projection="3d", facecolor="white")
surf4 = ax4.plot_surface(x, y, z4, cmap="Oranges", edgecolor='none')
ax4.set_title(title_pest_infestation, fontsize=font_size, pad=title_pad)
ax4.set_xlabel(x_label, fontsize=font_size)
ax4.set_ylabel(y_label, fontsize=font_size)
ax4.set_zlabel(z_label_pest, fontsize=font_size)

# Make sure all subplots have a consistent view initialization
for ax in [ax1, ax2, ax3, ax4]:
    ax.view_init(30, 45)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and spacing
plt.tight_layout()

# Save the plot to a file
plt.savefig("3d_72.pdf", bbox_inches="tight")

