

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Define the data for the earth science metrics surface plots
x = np.linspace(-50, 50, 200)  
y = np.linspace(-50, 50, 200)  
x, y = np.meshgrid(x, y)

# Example earth science metrics
z1 = 20 * np.sin(0.1 * x) + 0.5 * y  # Temperature Distribution - sine wave with linear trend
z2 = 50 * (np.sin(0.05 * x) * np.cos(0.05 * y)) + 100  # Rainfall Distribution - oscillating pattern
z3 = 100 * np.exp(-0.01 * (x**2 + y**2))  # Altitude Variation - Gaussian peak
z4 = 1 / (1 + np.exp(0.05 * (x**2 + y**2)))  # Vegetation Density - logistic function

# Text variables for earth science domain
title_temperature_distribution = "Temperature Distribution"
title_rainfall_distribution = "Rainfall Distribution"
title_altitude_variation = "Altitude Variation"
title_vegetation_density = "Vegetation Density"
x_label = "Longitude"
y_label = "Latitude"
z_label_temperature = "Temperature (°C)"
z_label_rainfall = "Rainfall (mm)"
z_label_altitude = "Altitude (m)"
z_label_vegetation = "Vegetation Density"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
font_size = 12
title_pad = 10

# Create a figure with specified size
fig = plt.figure(figsize=(14, 10))

# Plot the first subplot - Temperature Distribution
ax1 = fig.add_subplot(141, projection="3d", facecolor="white")
surf1 = ax1.plot_surface(x, y, z1, cmap="viridis", edgecolor='none')
ax1.set_title(title_temperature_distribution, fontsize=font_size, pad=title_pad)
ax1.set_xlabel(x_label, fontsize=font_size)
ax1.set_ylabel(y_label, fontsize=font_size)
ax1.set_zlabel(z_label_temperature, fontsize=font_size)

# Plot the second subplot - Rainfall Distribution
ax2 = fig.add_subplot(142, projection="3d", facecolor="white")
surf2 = ax2.plot_surface(x, y, z2, cmap="plasma", edgecolor='none')
ax2.set_title(title_rainfall_distribution, fontsize=font_size, pad=title_pad)
ax2.set_xlabel(x_label, fontsize=font_size)
ax2.set_ylabel(y_label, fontsize=font_size)
ax2.set_zlabel(z_label_rainfall, fontsize=font_size)

# Plot the third subplot - Altitude Variation
ax3 = fig.add_subplot(143, projection="3d", facecolor="white")
surf3 = ax3.plot_surface(x, y, z3, cmap="inferno", edgecolor='none')
ax3.set_title(title_altitude_variation, fontsize=font_size, pad=title_pad)
ax3.set_xlabel(x_label, fontsize=font_size)
ax3.set_ylabel(y_label, fontsize=font_size)
ax3.set_zlabel(z_label_altitude, fontsize=font_size)

# Plot the fourth subplot - Vegetation Density
ax4 = fig.add_subplot(144, projection="3d", facecolor="white")
surf4 = ax4.plot_surface(x, y, z4, cmap="cividis", edgecolor='none')
ax4.set_title(title_vegetation_density, fontsize=font_size, pad=title_pad)
ax4.set_xlabel(x_label, fontsize=font_size)
ax4.set_ylabel(y_label, fontsize=font_size)
ax4.set_zlabel(z_label_vegetation, fontsize=font_size)

# Ensure all subplots have a consistent view initialization
for ax in [ax1, ax2, ax3, ax4]:
    ax.view_init(30, 45)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and spacing
plt.tight_layout()

# Save the plot to a file
plt.savefig("3d_74.pdf", bbox_inches="tight")

