
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Sample data for electric vehicles
years = ["2010", "2012", "2014", "2016", "2018", "2020", "2022", "2024"]
Manufacturer_A = [10, 20, 35, 50, 75, 120, 200, 300]
Manufacturer_B = [8, 18, 33, 45, 70, 110, 180, 250]
Manufacturer_C = [5, 15, 25, 40, 60, 100, 150, 220]
Manufacturer_D = [7, 17, 30, 48, 72, 115, 190, 260]
adoption_rate = [0.01, 0.03, 0.05, 0.08, 0.12, 0.18, 0.25, 0.35]
labels = ["Manufacturer_A", "Manufacturer_B", "Manufacturer_C", "Manufacturer_D"]
xlabel = "Year"
ylabel1 = "EVs Sold (in thousands)"
ylabel2 = "Adoption Rate (%)"
legend_title = "EV Manufacturers"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax1 = plt.subplots(figsize=(10, 6))

# Bar plot
bar_width = 0.2
index = np.arange(len(years))

# Defining colors as variables
color_A = "#FF9999"  # Light Red
color_B = "#66B3FF"  # Light Blue
color_C = "#99FF99"  # Light Green
color_D = "#FFCC99"  # Light Orange
line_color = "purple"

ax1.bar(index, Manufacturer_A, bar_width, label=labels[0], color=color_A)
ax1.bar(index + bar_width, Manufacturer_B, bar_width, label=labels[1], color=color_B)
ax1.bar(index + 2 * bar_width, Manufacturer_C, bar_width, label=labels[2], color=color_C)
ax1.bar(index + 3 * bar_width, Manufacturer_D, bar_width, label=labels[3], color=color_D)

# Line plot
ax2 = ax1.twinx()
ax2.plot(
    years,
    adoption_rate,
    color=line_color,
    marker="D",
    linestyle="--",
    linewidth=2,
    markersize=7,
)

# Annotate adoption rate percentages
for i, rate in enumerate(adoption_rate):
    ax2.annotate(
        f"{rate*100:.1f}%",
        (index[i] + bar_width * 1.5, rate),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        color=line_color,
    )

# Set labels and title
ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel1)
ax2.set_ylabel(ylabel2)

# Set x-axis tick labels
ax1.set_xticks(index + bar_width * 1.5)
ax1.set_xticklabels(years)

# Add legend
ax1.legend(loc="upper left", ncol=1, bbox_to_anchor=(1, 1), title=legend_title)
ax1.grid(axis="y")
ax1.set_axisbelow(True)

# Set ax2.yticklabels to be percentages
ax2.set_yticklabels([f"{x*100:.0f}%" for x in ax2.get_yticks()])

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
# Save the plot as a PDF file
plt.savefig("CB_105.pdf", bbox_inches="tight")
