

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Education sectors
education_sectors = [
    "Primary Education",
    "Secondary Education",
    "Higher Education",
    "Vocational Training",
    "Online Courses",
    "Adult Education",
    "Special Education",
    "Technical Institutes",
    "Private Tutoring",
    "Educational TV",
]

# Enrollment metrics in 2010 (in millions of students)
enrollment_2010 = [50, 40, 30, 20, 10, 5, 15, 25, 10, 5]
# Enrollment metrics in 2020 (in millions of students)
enrollment_2020 = [60, 50, 35, 25, 30, 12, 20, 30, 20, 10]

x_label = "Millions of Students"
y_label = "Education Sector"
ax1_title = "Student Enrollment in 2010"
ax2_title = "Student Enrollment in 2020"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with two subplots (1x2) and shared y-axis
fig, axes = plt.subplots(1, 2, figsize=(12, 7), sharey=True)

colors = ["#1f77b4", "#ff7f0e"]
markers = ["o", "D"]

# Plotting the bar graphs
for i, (enrollment, color, marker) in enumerate(zip([enrollment_2010, enrollment_2020], colors, markers)):
    axes[i].barh(education_sectors, enrollment, color=color, edgecolor="gray", alpha=0.7)
    axes[i].set_xlabel(x_label)
    # Adding line graph on the same axes
    axes[i].plot(enrollment, education_sectors, marker=marker, linestyle="--", color="#2ca02c", linewidth=2)

# Adding data labels
for ax, enrollment in zip(axes, [enrollment_2010, enrollment_2020]):
    for index, value in enumerate(enrollment):
        ax.text(value + 1, index, f" {value}", va="center", fontsize=10)

# Set labels and titles
axes[0].set_title(ax1_title, fontsize=14)
axes[1].set_title(ax2_title, fontsize=14)
axes[0].set_ylabel(y_label, fontsize=12)

# Enhance overall visualization
plt.suptitle("Comparison of Student Enrollment Over Time", fontsize=16)
plt.grid(True, which='major', linestyle='--', linewidth=0.5)
plt.tight_layout(rect=[0, 0, 1, 0.96])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent clipping and overlap
plt.savefig("CB_115.pdf", bbox_inches="tight")
