

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample political data
quarters = ["Q1", "Q2", "Q3", "Q4"]
partyA = [12, 15, 14, 16]
partyB = [13, 16, 15, 17]
partyC = [14, 17, 16, 18]
partyD = [15, 18, 17, 19]
popularity_rate = [0.65, 0.60, 0.70, 0.75]

# Errors (e.g., standard deviation)
errorA = [1, 2, 1.5, 1.8]
errorB = [1.1, 2.1, 1.6, 1.9]
errorC = [1.2, 2.2, 1.7, 2.0]
errorD = [1.3, 2.3, 1.8, 2.1]
error_recovery = [0.05, 0.04, 0.03, 0.02]
labels = ["Party A", "Party B", "Party C", "Party D"]
xlabel = "Quarter"
ylabel1 = "Number of Policies Enacted"
ylabel2 = "Popularity Rate (%)"
legend_title = "Political Parties"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax1 = plt.subplots(figsize=(8, 6))

# Bar plot with error bars
bar_width = 0.2
index = np.arange(len(quarters))
ax1.bar(
    index,
    partyA,
    bar_width,
    label=labels[0],
    color="lightblue",
    yerr=errorA,
    capsize=5,
    ecolor="navy",
)
ax1.bar(
    index + bar_width,
    partyB,
    bar_width,
    label=labels[1],
    color="lightgreen",
    yerr=errorB,
    capsize=5,
    ecolor="darkgreen",
)
ax1.bar(
    index + 2 * bar_width,
    partyC,
    bar_width,
    label=labels[2],
    color="lavender",
    yerr=errorC,
    capsize=5,
    ecolor="purple",
)
ax1.bar(
    index + 3 * bar_width,
    partyD,
    bar_width,
    label=labels[3],
    color="peachpuff",
    yerr=errorD,
    capsize=5,
    ecolor="sienna",
)

# Line plot with error bars
ax2 = ax1.twinx()
ax2.errorbar(
    index + 1.5 * bar_width,
    popularity_rate,
    yerr=error_recovery,
    fmt="o-",
    color="coral",
    label="Popularity Rate",
    linewidth=2,
    markersize=5,
    capsize=5,
)

# Set labels and title
ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel1)
ax2.set_ylabel(ylabel2)

# Set x-axis tick labels
ax1.set_xticks(index + 1.5 * bar_width)
ax1.set_xticklabels(quarters)

# Add legends
ax1.legend(loc="lower center", ncol=4, bbox_to_anchor=(0.5, -0.25), title=legend_title)
ax2.legend(loc="upper left", ncol=1)

# Set ax2.yticklabels to be percentage
ax2.set_ylim(0, 1)
ax2.set_yticks(np.linspace(0, 1, 11))
ax2.set_yticklabels([f"{x*100:.0f}%" for x in ax2.get_yticks()])

# Grid and layout adjustment
ax1.grid(axis="y")
ax1.set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("CB_118.pdf", bbox_inches="tight")

