
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data
regions = ["North", "South", "East", "West", "Central", "International"]
Q1_sales = [120, 150, 130, 170, 160, 200]
Q2_sales = [140, 155, 160, 180, 170, 220]
Q3_sales = [160, 165, 150, 190, 180, 230]
sales_trend = [140, 157, 147, 180, 170, 217]
labels = ["Q1 Sales", "Q2 Sales", "Q3 Sales", "Sales Trend"]

xlabel = "Region"
ylabel = "Sales (in thousands)"
title = "Quarterly Sales Performance by Region"
yticks = np.arange(100, 251, 25)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(10, 6))

bar_width = 0.25
index = np.arange(len(regions))

color_Q1 = "#ffcccb"
color_Q2 = "#add8e6"
color_Q3 = "#90ee90"
color_trend = "#ffa500"

bar1 = ax.bar(index, Q1_sales, bar_width, label=labels[0], color=color_Q1, edgecolor="grey")
bar2 = ax.bar(index + bar_width, Q2_sales, bar_width, label=labels[1], color=color_Q2, edgecolor="grey")
bar3 = ax.bar(index + 2 * bar_width, Q3_sales, bar_width, label=labels[2], color=color_Q3, edgecolor="grey")

# Trend line for 'Sales Trend'
ax.plot(index, sales_trend, color=color_trend, marker="o", linestyle="dashed", label=labels[3], linewidth=2)

# Adding sales values on top of the bars
for i, rect in enumerate(bar1 + bar2 + bar3):
    height = rect.get_height()
    ax.text(rect.get_x() + rect.get_width() / 2.0, height, f"{height}k", ha="center", va="bottom")

# Labels, title and custom x-axis tick labels
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_yticks(yticks)
ax.set_title(title, fontsize=15)
ax.set_xticks(index + bar_width)
ax.set_xticklabels(regions, rotation=30)
ax.legend(fontsize=10)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("CB_35.pdf", bbox_inches="tight")
