
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
continents = ["Africa", "Asia", "Europe", "North America", "South America", "Oceania"]
population_density = [10, 20, 30, 40, 50, 60]
gdp_growth_rate = [5, 7, 6, 8, 6, 7]
internet_penetration = [25, 50, 75, 85, 60, 90]
renewable_energy_utilization = [35, 45, 50, 55, 40, 70]
labels = ["Population Density", "GDP Growth Rate", "Internet Penetration", "Renewable Energy Utilization"]

xlabel = "Continent"
ylabel = "Percentage (%)"
title = "Geographical Metrics for Different Continents"
yticks = np.arange(0, 101, 10)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(10, 6))  # Adjusting figure size

bar_width = 0.25
index = np.arange(len(continents))

bar1 = ax.bar(index, population_density, bar_width, label=labels[0], color="#5DADE2", edgecolor="grey")
bar2 = ax.bar(index + bar_width, gdp_growth_rate, bar_width, label=labels[1], color="#52BE80", edgecolor="grey")
bar3 = ax.bar(index + 2 * bar_width, internet_penetration, bar_width, label=labels[2], color="#F4D03F", edgecolor="grey")

# Trend line for 'Renewable Energy Utilization'
ax.plot(index + bar_width, renewable_energy_utilization, color="#EC7063", marker="D", linestyle="--", markersize=8, label=labels[3])

# Adding percentages on top of the bars
for rects in [bar1, bar2, bar3]:
    for rect in rects:
        height = rect.get_height()
        ax.text(rect.get_x() + rect.get_width() / 2.0, height, f"{height}%", ha="center", va="bottom")

# Labels, title and custom x-axis tick labels
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_yticks(yticks)
ax.set_title(title)
ax.set_xticks(index + 1.5 * bar_width)
ax.set_xticklabels(continents, rotation=45)
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("CB_36.pdf", bbox_inches="tight")
