

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# New data for the weather domain
np.random.seed(42)
# Simulating plausible weather data
x = np.random.normal(20, 5, 300)  # Temperature (°C)
y = np.random.normal(60, 10, 300) + 0.2 * x  # Humidity (%)
xlabel = "Temperature (°C)"
ylabel = "Humidity (%)"
title = "Relationship between Temperature and Humidity"
supertitle = "Weather Metrics Analysis"
filename = "CB_44_4.pdf"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Start with a square Figure.
fig = plt.figure(figsize=(6, 6))
# Add a gridspec with two rows and two columns and a ratio of 1 to 4 between
# the size of the marginal axes and the main axes in both directions.
# Also adjust the subplot parameters for a square plot.
gs = fig.add_gridspec(
    2,
    2,
    width_ratios=(4, 1),
    height_ratios=(1, 4),
    left=0.1,
    right=0.9,
    bottom=0.1,
    top=0.9,
    wspace=0.0,
    hspace=0.0,
)
# Create the Axes.
ax = fig.add_subplot(gs[1, 0])
ax_histx = fig.add_subplot(gs[0, 0], sharex=ax)
ax_histy = fig.add_subplot(gs[1, 1], sharey=ax)

# Draw the scatter plot and marginals.
# no labels
ax_histx.tick_params(axis="x", labelbottom=False)
ax_histy.tick_params(axis="y", labelleft=False)

# the scatter plot:
ax.scatter(x, y, color="#1f77b4", alpha=0.6, edgecolor="black", s=50)

# now determine nice limits by hand:
binwidth = 2
xymax = max(np.max(np.abs(x)), np.max(np.abs(y)))
lim = (int(xymax / binwidth) + 1) * binwidth

bins = np.arange(0, lim + binwidth, binwidth)
ax_histx.hist(x, bins=bins, color="#aec7e8", edgecolor="#1f77b4")
ax_histy.hist(
    y, bins=bins, orientation="horizontal", color="#aec7e8", edgecolor="#1f77b4"
)

# remove the y-axis labels
ax_histx.set_yticks([])
ax_histy.set_xticks([])

# remove the top, left, and right spines
ax_histx.spines["top"].set_visible(False)
ax_histx.spines["left"].set_visible(False)
ax_histx.spines["right"].set_visible(False)
ax_histy.spines["top"].set_visible(False)
ax_histy.spines["bottom"].set_visible(False)
ax_histy.spines["right"].set_visible(False)

ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
fig.suptitle(supertitle)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("CB_44.pdf", bbox_inches="tight")

