

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
x = np.array([9.0, 9.1, 9.2, 9.3, 9.4, 9.5, 9.6, 9.7, 9.8, 9.9, 10.0])
y = np.array([9.1, 9.0, 9.3, 9.4, 9.5, 9.4, 9.7, 9.6, 9.8, 9.7, 9.9])
percentages = [
    "1.1%",
    "-1.1%",
    "1.1%",
    "1.1%",
    "1.0%",
    "-1.1%",
    "1.0%",
    "-1.0%",
    "0.0%",
    "-2.0%",
    "-1.0%",
]

# Axes Limits and Labels
xlabel_value = "Theoretical Acceleration due to Gravity (m/s²)"
ylabel_value = "Measured Acceleration due to Gravity (m/s²)"
xticklabels = [f"{num} m/s²" for num in x]
yticklabels = [f"{num} m/s²" for num in y]
title_value = "Comparison of Theoretical vs. Measured Acceleration"
supertitle_value = "Acceleration Data under Gravitational Force"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(8, 6))

# Plot data with different marker style
ax.plot(x, y, color="teal", linestyle='--', linewidth=2)
ax.scatter(x, y, marker="^", color="orange", s=100)

# Annotate percentages with different font style
for i, txt in enumerate(percentages):
    ax.annotate(
        txt,
        (x[i], y[i]),
        textcoords="offset points",
        xytext=(0, 10),
        ha="center",
        fontsize=9,
    )

# Set labels with different font style
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value, fontsize=12)
ax.set_title(title_value, fontsize=14)
fig.suptitle(supertitle_value, fontsize=16, fontweight='bold')

# Set ticks
ax.set_xticks(x)
ax.set_yticks(y)

# Set tick labels with different font style
ax.set_xticklabels(xticklabels, fontsize=9)
ax.set_yticklabels(yticklabels, fontsize=9)

# Set grid with lighter lines
ax.grid(True, linestyle="--", linewidth=0.5, color="gray")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("CB_51.pdf", bbox_inches="tight")

