

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)  # Different seed for new data

# Data
methods = ["Lecture", "E-learning", "Group Study", "Project-Based"]
effectiveness_srcc = [0.760, 0.820, 0.690, 0.850]
engagement_plcc = [0.740, 0.810, 0.720, 0.830]
combined_index = [1.500, 1.630, 1.410, 1.680]

# Labels and Titles
labels = ["Effectiveness Index (SRCC)", "Engagement Index (PLCC)", "Combined Index (SRCC + PLCC)"]
xlabel = "Learning Methods"
ylabel = "Index Values"
title = "Comparison of Learning Methods"
legend_labels = ["Effectiveness", "Engagement", "Combined Index"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar plot
fig, ax1 = plt.subplots(figsize=(12, 7))  # Increased figure size for better clarity

bar_width = 0.35
index = np.arange(len(methods))
color_srcc = "#6a5acd"  # Color for SRCC bars
color_plcc = "#4682b4"  # Color for PLCC bars
color_combined = "#dc143c"  # Color for the combined line

bar1 = ax1.bar(index, effectiveness_srcc, bar_width, label=legend_labels[0], color=color_srcc)
bar2 = ax1.bar(index + bar_width, engagement_plcc, bar_width, label=legend_labels[1], color=color_plcc)

# Line plot
ax2 = ax1.twinx()
line = ax2.plot(index + bar_width / 2, combined_index, color=color_combined, marker="D", linewidth=2, markersize=8, label=legend_labels[2])

# Annotate bars with values
for rect, value in zip(bar1, effectiveness_srcc):
    height = rect.get_height()
    ax1.text(rect.get_x() + rect.get_width() / 2, height + 0.005, f"{value:.3f}", ha="center", va="bottom")

for rect, value in zip(bar2, engagement_plcc):
    height = rect.get_height()
    ax1.text(rect.get_x() + rect.get_width() / 2, height + 0.005, f"{value:.3f}", ha="center", va="bottom")

# Labels, title and legend
ax1.set_xlabel(xlabel, fontsize=12)
ax1.set_ylabel(ylabel, fontsize=12)
ax1.set_title(title, fontsize=14)
ax1.set_xticks(index + bar_width / 2)
ax1.set_xticklabels(methods, fontsize=11)
ax1.set_ylim(0.65, 0.90)
ax1.set_yticks(np.arange(0.65, 0.91, 0.05))
ax2.set_ylim(1.30, 1.75)
ax2.set_yticks(np.arange(1.30, 1.76, 0.10))
ax1.legend(loc="upper left", fontsize=10)
ax2.legend(loc="upper right", fontsize=10)

ax1.yaxis.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust figure size to match original image's dimensions
fig.set_size_inches(12, 7)

# Show plot
plt.tight_layout()
plt.savefig("CB_55.pdf", bbox_inches="tight")
