
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
countries = ["Country A", "Country B", "Country C", "Country D"]
gdp_values = [0.03, 0.04, 0.035, 0.025]  # GDP Growth Rates
unemployment_values = [0.05, 0.045, 0.04, 0.03]  # Unemployment Rates
aggregate_values = [0.98, 0.995, 0.995, 0.995]  # Aggregate Economic Score (1 - (Unemployment Rate + (1-GDP Growth Rate)))
labels = ["GDP Growth Rate", "Unemployment Rate", "Aggregate Economic Score"]
xlabel = "Countries"
ylabel = "Economic Indicators"
title = "Economic Performance of Different Countries"
legendlabels = ["GDP Growth Rate", "Unemployment Rate", "Aggregate Economic Score"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar plot
fig, ax1 = plt.subplots(
    figsize=(10, 6)
)  # Adjust the figsize to match the original image's dimensions

bar_width = 0.35
index = np.arange(len(countries))

# Colors
color_gdp = "#87CEEB"  # Pastel blue
color_unemployment = "#90EE90"  # Light green
color_aggregate = "#FFA07A"  # Light coral with diamond marker

bar1 = ax1.bar(index, gdp_values, bar_width, label=labels[0], color=color_gdp)
bar2 = ax1.bar(
    index + bar_width, unemployment_values, bar_width, label=labels[1], color=color_unemployment
)

# Line plot
ax2 = ax1.twinx()
(line,) = ax2.plot(index + bar_width / 2, aggregate_values, color=color_aggregate, marker="D", linestyle='-', label=labels[2])

# Annotate bars with values
for rect, value in zip(bar1, gdp_values):
    height = rect.get_height()
    ax1.text(
        rect.get_x() + rect.get_width() / 2,
        height + 0.002,
        f"{value:.3f}",
        ha="center",
        va="bottom",
    )

for rect, value in zip(bar2, unemployment_values):
    height = rect.get_height()
    ax1.text(
        rect.get_x() + rect.get_width() / 2,
        height + 0.002,
        f"{value:.3f}",
        ha="center",
        va="bottom",
    )

# Labels, title and legend
ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel)
ax1.set_title(title)
ax1.set_xticks(index + bar_width / 2)
ax1.set_xticklabels(countries)
ax1.set_ylim(0.02, 0.06)
ax1.set_yticks([0.02, 0.03, 0.04, 0.05, 0.06])
ax2.set_ylim(0.95, 1)
ax2.set_yticks([0.95, 0.96, 0.97, 0.98, 0.99, 1.00])
ax1.legend(loc="upper left")
ax2.legend(loc="upper right")

ax1.yaxis.grid(True, linestyle='--', linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Adjust figure size to match original image's dimensions
fig.set_size_inches(10, 6)

# Show plot
plt.tight_layout()
plt.savefig("CB_57.pdf", bbox_inches="tight")
