
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample (x, y) for the scatter plot representing Traffic Density vs. Average Speed
data = {
    "Very Low": [[np.random.rand() * 20, np.random.rand() * 20 + 60] for _ in range(10)],
    "Low": [[np.random.rand() * 20 + 20, np.random.rand() * 20 + 40] for _ in range(10)],
    "Medium": [[np.random.rand() * 20 + 40, np.random.rand() * 20 + 20] for _ in range(10)],
    "High": [[np.random.rand() * 20 + 60, np.random.rand() * 20] for _ in range(10)],
}

line_x = np.array([0, 80])
line_y = np.array([80, 0])
labels = ["Very Low", "Low", "Medium", "High"]
correlation = -0.85
xlabel = "Traffic Density (vehicles per km)"
ylabel = "Average Speed (km/h)"
correlation_text = f"Correlation: {correlation:.2f}"
title = "Traffic Density vs. Average Speed"
supertitle = "Scatter Plot with Regression Line"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = [
    "#1f77b4",  # Blue
    "#ff7f0e",  # Orange
    "#2ca02c",  # Green
    "#d62728",  # Red
]
markers = ['o', 's', 'D', '^']  # Circle, Square, Diamond, Triangle Up

# Create scatter plot
plt.figure(figsize=(9, 6))  # Adjust figure size

for idx, key in enumerate(data):
    x = [item[0] for item in data[key]]
    y = [item[1] for item in data[key]]
    plt.scatter(x, y, color=colors[idx], label=key, marker=markers[idx])

# Add regression line
plt.plot(line_x, line_y, color="black", linestyle='--', linewidth=1.5)

# Add shaded area for standard deviation
std_dev = 10
plt.fill_between(line_x, line_y - std_dev, line_y + std_dev, color="black", alpha=0.1)

# Add legend inside the plot area
plt.legend(loc="upper center",ncol=4)

# Add correlation text with a box inside the plot area
plt.text(line_x.mean(), line_y.mean(), correlation_text, fontsize=10, bbox=dict(facecolor='white', alpha=0.7))

# Set labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.suptitle(supertitle)

# Set grid
plt.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("CB_62.pdf", bbox_inches="tight")
