
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Sample (x,y) for the scatter plot representing philosophical influence over time
data = {
    "Ancient Philosophy": [[np.random.rand(), np.random.rand() * 10] for _ in range(15)],
    "Medieval Philosophy": [[np.random.rand(), np.random.rand() * 8] for _ in range(15)],
    "Modern Philosophy": [[np.random.rand(), np.random.rand() * 6] for _ in range(15)],
    "Contemporary Philosophy": [[np.random.rand(), np.random.rand() * 4] for _ in range(15)],
}

line_x = np.array([0.0, 1.0])
line_y = np.array([0, 5])  # Hypothetical regression line
labels = ["Contemporary Philosophy", "Modern Philosophy", "Medieval Philosophy", "Ancient Philosophy"]
correlation = 0.78
xlabel = "Time (Centuries)"
ylabel = "Influence Index"
correlation_text = f"Correlation: {correlation:.2f}"
title = "Influence of Philosophical Doctrines Over Time"
legendtitle="Philosophy Era"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = [
    "#2ca02c",  # Green
    "#1f77b4",  # Blue
    "#ff7f0e",  # Orange
    "#d62728",  # Red
]  # Professional color scheme for data visualization

# Create scatter plot
plt.figure(figsize=(10, 6))  # Adjust figure size to improve readability

for key in data:
    x = [item[0] for item in data[key]]
    y = [item[1] for item in data[key]]
    plt.scatter(x, y, color=colors[labels.index(key)], label=key, edgecolor='k', s=100, alpha=0.7)

# Add regression line with dashed style
plt.plot(line_x, line_y, color="black", linestyle='--')

# Add shaded area for standard deviation
std_dev = 2.5
plt.fill_between(line_x, line_y - std_dev, line_y + std_dev, color="grey", alpha=0.2)

# Add legend inside the plot area
plt.legend(loc="upper left", title=legendtitle)

# Add correlation text with a box inside the plot area
plt.text(line_x.mean(), line_y.mean(), correlation_text, fontsize=12, bbox=dict(facecolor='white', edgecolor='black'))

# Set labels, title, and grid
plt.xlabel(xlabel, fontsize=12)
plt.ylabel(ylabel, fontsize=12)
plt.title(title, fontsize=14)
plt.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("CB_63.pdf", bbox_inches="tight")
