

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
quarters = ["Q1", "Q2", "Q3", "Q4"]
stock_prices_method1 = [120, 130, 125, 135]
stock_prices_method1_post_forecast = [122, 132, 127, 137]
stock_prices_method2 = [118, 128, 123, 133]
stock_prices_method2_post_forecast = [121, 129, 126, 134]
stock_prices_best = [123, 131, 128, 136]
stock_prices_iterative_best = [125, 133, 129, 138]
stock_prices_sum_best = [126, 134, 130, 139]
trend = [121, 130, 127, 135]
title = "Comparison of Stock Prices Across Quarters"
labels = [
    "Method1",
    "Method1-Post-Forecast",
    "Method2",
    "Method2-Post-Forecast",
    "Best",
    "Iterative-Post-Forecast",
    "Sum-best",
    "Trend",
]
x_label = "Quarters"
y_label = "Stock Prices"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match the original image's dimensions
plt.figure(figsize=(10, 4))

# Bar width
barWidth = 0.1

# Set position of bar on X axis
r1 = np.arange(len(stock_prices_method1))
r2 = [x + barWidth for x in r1]
r3 = [x + barWidth for x in r2]
r4 = [x + barWidth for x in r3]
r5 = [x + barWidth for x in r4]
r6 = [x + barWidth for x in r5]
r7 = [x + barWidth for x in r6]

# Make the plot
plt.bar(
    r1,
    stock_prices_method1,
    color="#66c2a5",
    width=barWidth,
    edgecolor="white",
    label=labels[0],
)
plt.bar(
    r2,
    stock_prices_method1_post_forecast,
    color="#fc8d62",
    width=barWidth,
    edgecolor="white",
    label=labels[1],
    hatch="\\",
)
plt.bar(
    r3,
    stock_prices_method2,
    color="#8da0cb",
    width=barWidth,
    edgecolor="white",
    label=labels[2],
)
plt.bar(
    r4,
    stock_prices_method2_post_forecast,
    color="#e78ac3",
    width=barWidth,
    edgecolor="white",
    label=labels[3],
    hatch="\\",
)
plt.bar(
    r5,
    stock_prices_best,
    color="#a6d854",
    width=barWidth,
    edgecolor="white",
    label=labels[4],
)
plt.bar(
    r6,
    stock_prices_iterative_best,
    color="#ffd92f",
    width=barWidth,
    edgecolor="white",
    label=labels[5],
)
plt.bar(
    r7,
    stock_prices_sum_best,
    color="#e5c494",
    width=barWidth,
    edgecolor="white",
    label=labels[6],
)

# Add trend line
plt.plot(
    r1, 
    trend, 
    color="gray", 
    marker="o", 
    linestyle="--", 
    linewidth=2, 
    markersize=6, 
    label=labels[7]
)

# Add xticks on the middle of the group bars
plt.xlabel(x_label)
plt.ylabel(y_label)
plt.xticks([r + barWidth * 3 for r in range(len(stock_prices_method1))], quarters)
plt.ylim(110, 140)
plt.yticks([115, 120, 125, 130, 135, 140])

# Create legend & Show graphic
plt.title(title)
plt.legend(loc="upper center", ncol=4)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("CB_68.pdf", bbox_inches="tight")

