

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
tasks = ["Battery Life", "Screen Quality", "Processor Speed", "Camera Quality"]
scores_step1 = [0.60, 0.70, 0.80, 0.75]
scores_step1_APE = [0.62, 0.72, 0.83, 0.78]
scores_step2 = [0.68, 0.75, 0.85, 0.80]
scores_step2_APE = [0.70, 0.78, 0.88, 0.83]
scores_best = [0.75, 0.82, 0.90, 0.85]
scores_iterative_best = [0.72, 0.79, 0.87, 0.83]
scores_sum_best = [0.74, 0.81, 0.89, 0.84]
trend = [0.65, 0.76, 0.84, 0.79]
title = "Comparison of Tech Gadget Performance Metrics"
labels = [
    "Method1-Step1", 
    "Method1-Step1-APE", 
    "Method2-Step2", 
    "Method2-Step2-APE", 
    "Method-Best", 
    "Iterative-APE-Best", 
    "Sum-Best", 
    "Overall-Trend"
]
x_label = "Tech Gadget Metrics"
y_label = "Scores"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match the original image's dimensions
plt.figure(figsize=(10, 4))

# Bar width
barWidth = 0.1

# Set position of bar on X axis
r1 = np.arange(len(scores_step1))
r2 = [x + barWidth for x in r1]
r3 = [x + barWidth for x in r2]
r4 = [x + barWidth for x in r3]
r5 = [x + barWidth for x in r4]
r6 = [x + barWidth for x in r5]
r7 = [x + barWidth for x in r6]

# Make the plot
plt.bar(
    r1,
    scores_step1,
    color="#adebad",
    width=barWidth,
    edgecolor="white",
    label=labels[0],
)
plt.bar(
    r2,
    scores_step1_APE,
    color="#adebad",
    width=barWidth,
    edgecolor="white",
    label=labels[1],
    hatch="\\",
)
plt.bar(
    r3,
    scores_step2,
    color="#66cc66",
    width=barWidth,
    edgecolor="white",
    label=labels[2],
)
plt.bar(
    r4,
    scores_step2_APE,
    color="#66cc66",
    width=barWidth,
    edgecolor="white",
    label=labels[3],
    hatch="\\",
)
plt.bar(
    r5,
    scores_best,
    color="#339933",
    width=barWidth,
    edgecolor="white",
    label=labels[4],
)
plt.bar(
    r6,
    scores_iterative_best,
    color="#999999",
    width=barWidth,
    edgecolor="white",
    label=labels[5],
)
plt.bar(
    r7,
    scores_sum_best,
    color="#4d9900",
    width=barWidth,
    edgecolor="white",
    label=labels[6],
)

# Add trend line
plt.plot(
    tasks,
    trend,
    color="#000000",
    marker="s",
    linestyle="--",
    linewidth=2,
    markersize=6,
    label=labels[7],
)

# Add xticks on the middle of the group bars
plt.xlabel(x_label)
plt.ylabel(y_label)
plt.xticks([r + barWidth * 3 for r in range(len(scores_step1))], tasks)
plt.ylim(0.5, 1.0)
plt.yticks([0.5, 0.6, 0.7, 0.8, 0.9, 1.0])

# Create legend & Show graphic
plt.title(title)
plt.legend(loc="upper center", ncol=4)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("CB_69.pdf", bbox_inches="tight")

