

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data for student test scores
scores_group_math = np.random.normal(70, 15, 1000)
scores_group_science = np.random.normal(75, 10, 1000)

min_bin = 0
max_bin = 100

bins = np.linspace(min_bin, max_bin, 30)
bin_width = bins[1] - bins[0]
labels = ["Math Scores", "Science Scores"]
legend_title = "Subjects"
title = "Distribution of Student Test Scores in Math and Science"
xlabel = "Scores"
ylabel = "Count"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
figure = plt.figure(figsize=(10, 6))

# Create histogram
count_math, bins_math, _ = plt.hist(
    scores_group_math,
    bins=bins,
    color="#8bc34a",
    alpha=0.7,
    label=labels[0],
    edgecolor="black",
    linewidth=1.25,
)
count_science, bins_science, _ = plt.hist(
    scores_group_science,
    bins=bins,
    alpha=0.7,
    color="#ff9800",
    label=labels[1],
    edgecolor="black",
    linewidth=1.25,
)

# Create line plot on top of the histogram with different styles
plt.plot(bins_math[:-1] + bin_width * 0.5, count_math, color="#388e3c", linewidth=1.5, linestyle='-')
plt.plot(bins_science[:-1] + bin_width * 0.5, count_science, color="#f57c00", linewidth=1.5, linestyle='--')

# Add grid for better readability
plt.grid(True, linestyle='--', alpha=0.5)

# Add legend, title, and labels
plt.legend(loc="upper right", title=legend_title)
plt.title(title)
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("CB_70.pdf", bbox_inches="tight")

