
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data representing Satisfaction Ratings for Digital and Traditional Art
satisfaction_digital = np.random.normal(80, 10, 1000)
satisfaction_traditional = np.random.normal(70, 15, 1000)

min_bin = min(min(satisfaction_digital), min(satisfaction_traditional))
max_bin = max(max(satisfaction_digital), max(satisfaction_traditional))

bins = np.linspace(min_bin, max_bin, 30)
bin_width = bins[1] - bins[0]
labels = ["Digital Art", "Traditional Art"]
legend_title = "Art Type"
title = "Satisfaction Ratings Comparison"
xlabel = "Satisfaction Rating (0-100)"
ylabel = "Frequency"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
figure = plt.figure(figsize=(10, 6))

# Create histogram
count_digital, bins_digital, _ = plt.hist(
    satisfaction_digital,
    bins=bins,
    color="#78c679",
    alpha=0.7,
    label=labels[0],
    edgecolor="#238443",
    linewidth=1.25,
)
count_traditional, bins_traditional, _ = plt.hist(
    satisfaction_traditional,
    bins=bins,
    alpha=0.7,
    color="#41b6c4",
    label=labels[1],
    edgecolor="#225ea8",
    linewidth=1.25,
)

# Create line plot on top of the histogram and set edge color
plt.plot(bins_digital[:-1] + bin_width * 0.5, count_digital, color="#005a32", linewidth=1.5, linestyle='--')
plt.plot(bins_traditional[:-1] + bin_width * 0.5, count_traditional, color="#045a8d", linewidth=1.5, linestyle='--')

# Add legend, title, and labels
plt.legend(loc="upper right", title=legend_title)
plt.title(title)
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Add gridlines for better readability
plt.grid(True, linestyle='--', alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("CB_72.pdf", bbox_inches="tight")
