
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for pie chart
pie_labels = ["Healthcare", "Technology", "Finance"]
pie_sizes = [30, 50, 20]
pie_counts = [300, 500, 200]

# Data for stacked bar chart
bar_labels = ["Stocks", "Bonds", "Real Estate"]
bar_sizes = [40, 30, 30]
bar_counts = [400, 300, 300]

# Text Labels
title = "Investment Distribution by Sector"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
pie_colors = ["#FF6F61", "#6B5B95", "#88B04B"]
bar_colors = ["#F7CAC9", "#92A8D1", "#034F84"]

# Pie chart
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(
    1, 2, figsize=(10, 5), gridspec_kw={"width_ratios": [6, 1]}
)

ax1.pie(
    pie_sizes,
    labels=pie_labels,
    colors=pie_colors,
    autopct=lambda p: "{:.1f}%\n({})".format(p, int(round(p * sum(pie_counts) / 100))),
    startangle=140,
    wedgeprops=dict(edgecolor='black')
)
ax1.axis("equal")  # Equal aspect ratio ensures that pie is drawn as a circle.

# Stacked bar chart
bar_positions = [0]  # Single bar at position 0
bottom = 0  # Initial bottom is 0 for the first bar segment

for size, color, count, bar_label in zip(bar_sizes, bar_colors, bar_counts, bar_labels):
    ax2.bar(
        bar_positions,
        [size],
        color=color,
        edgecolor='black',
        bottom=[bottom],
        label=bar_label,
        width=0.1,
    )
    # Calculate the middle position for the text
    mid_pos = bottom + (size / 2)
    # Add text annotation inside the bar
    ax2.text(
        0,
        mid_pos,
        "{} {}%".format(bar_label, size),
        color="black",
        ha="center",
        va="center",
        fontsize=9
    )
    bottom += size  # Update bottom for the next bar segment

ax2.set_axis_off()

# set the title
ax2.set_title(title, fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("CB_75.pdf", bbox_inches="tight")
