

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
sectors = ["Technology", "Healthcare", "Finance", "Education", "Manufacturing"]
# Generate random plausible data for average salaries and job availability
np.random.seed(0)
average_salaries = np.random.uniform(50000, 120000, size=len(sectors))
job_availability = np.random.uniform(5000, 20000, size=len(sectors))

# Axes Titles, Labels, and Limits
ax1_title = "Average Salaries by Sector"
ax1_ylabel = "Salary (USD)"
ax2_title = "Job Availability by Sector"
ax2_ylabel = "Number of Jobs"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 5))

# Bar chart for Average Salaries
ax1.bar(sectors, average_salaries, color="tomato")
ax1.plot(sectors, average_salaries, marker="o", color="darkred")
for i, salary in enumerate(average_salaries):
    ax1.text(i, salary, f"${salary:.1f}", ha="center", va="bottom")
ax1.set_title(ax1_title)
ax1.set_ylabel(ax1_ylabel)
ax1.set_facecolor("#fff3e0")

# Bar chart for Job Availability
ax2.bar(sectors, job_availability, color="skyblue")
ax2.plot(sectors, job_availability, marker="o", linestyle="--", color="royalblue")
for i, jobs in enumerate(job_availability):
    ax2.text(i, jobs, f"{jobs:.0f}", ha="center", va="bottom")
ax2.set_title(ax2_title)
ax2.set_ylabel(ax2_ylabel)
ax2.set_facecolor("#e0f7fa")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("CB_79.pdf", bbox_inches="tight")

