
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
vehicles = ["Sedan", "SUV", "Truck", "Motorcycle"]
fuel_consumption = [8.5, 12.0, 15.0, 3.5]
co2_emissions = [200, 270, 350, 90]

# Axes Limits and Labels
ax1_title = "Average Fuel Consumption by Vehicle Type"
ax1_ylim = [0, 16]
ax1_ylabel = "Fuel Consumption (L/100km)"
ax2_title = "Average CO₂ Emissions by Vehicle Type"
ax2_ylim = [0, 400]
ax2_ylabel = "CO₂ Emissions (g/km)"
sublabel_title = "Transport Efficiency Indicators by Vehicle Type"
legendlabels = ["Fuel Consumption", "CO₂ Emissions"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

# Color Variables
bar_color_1 = "#76c7c0"
line_color_1 = "#005f73"
text_color_1 = "#0a9396"
bar_color_2 = "#98c1d9"
line_color_2 = "#3d5a80"
text_color_2 = "#293241"
face_color = "#e0fbfc"

# Bar chart for Average Fuel Consumption
ax1.bar(vehicles, fuel_consumption, color=bar_color_1)
ax1.plot(vehicles, fuel_consumption, marker="^", linestyle="--", color=line_color_1, linewidth=2)
for i, rate in enumerate(fuel_consumption):
    ax1.text(i, rate, f"{rate:.1f}", ha="center", va="bottom", color=text_color_1)
ax1.set_title(ax1_title)
ax1.set_ylim(ax1_ylim)
ax1.set_ylabel(ax1_ylabel)
ax1.set_facecolor(face_color)

# Bar chart for Average CO₂ Emissions
ax2.bar(vehicles, co2_emissions, color=bar_color_2)
ax2.plot(vehicles, co2_emissions, marker="s", linestyle=":", color=line_color_2, linewidth=2)
for i, rate in enumerate(co2_emissions):
    ax2.text(i, rate, f"{rate}", ha="center", va="bottom", color=text_color_2)
ax2.set_title(ax2_title)
ax2.set_ylim(ax2_ylim)
ax2.set_ylabel(ax2_ylabel)
ax2.set_facecolor(face_color)

# Setting a supertitle
fig.suptitle(sublabel_title, fontsize=14)

# Adding legends
ax1.legend([legendlabels[0]], loc="upper left")
ax2.legend([legendlabels[1]], loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout(rect=[0, 0.03, 1, 0.95])
plt.savefig("CB_80.pdf", bbox_inches="tight")
