

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
time_months = np.array([1, 2, 3, 4, 5, 6])
party_a_ratings = np.array([45, 46, 48, 47, 49, 50])
party_b_ratings = np.array([55, 54, 53, 52, 51, 50])
error = np.array([2, 1.5, 1.8, 1.2, 1.5, 1.6])

xlabel = "Time (Months)"
ylabel = "Approval Rating (%)"
title = "Approval Ratings of Political Parties Over Time"
legend_party_a = "Party A"
legend_party_b = "Party B"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(8, 6))  # Adjusting figure size to 576x432 pixels

# Define Colors
color_party_a = "#2ca02c"
color_fill_a = "#b2df8a"
color_party_b = "#ff7f0e"
color_fill_b = "#ffbb78"

# Party A
ax.plot(
    time_months,
    party_a_ratings,
    marker="s",
    linestyle="--",
    color=color_party_a,
    label=legend_party_a,
)
ax.fill_between(
    time_months, party_a_ratings - error, party_a_ratings + error, color=color_fill_a, alpha=0.3
)

# Party B
ax.plot(
    time_months,
    party_b_ratings,
    marker="^",
    linestyle="-.",
    color=color_party_b,
    label=legend_party_b,
)
ax.fill_between(
    time_months, party_b_ratings - error, party_b_ratings + error, color=color_fill_b, alpha=0.3
)

# Customizing the plot
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xlim(0, 7)
ax.set_ylim(40, 60)
ax.legend(loc="lower right")
ax.grid(True)
ax.set_xticks(time_months)
ax.set_yticks(np.arange(40, 61, 4))

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("CB_82.pdf", bbox_inches="tight")
