
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
years = np.array([2010, 2012, 2014, 2016, 2018, 2020, 2022, 2024])
ev_adoption = np.array([1, 3, 7, 15, 30, 45, 60, 80])  # Percentage adoption of EVs
conventional_vehicles = np.array([95, 92, 88, 80, 70, 60, 50, 40])  # Percentage adoption of gasoline vehicles
error = np.array([5])

xlabel = "Year"
ylabel = "Vehicle Adoption Rate (%)"

errorbar_label = "Conventional Vehicles"
line_label = "Electric Vehicles"
title_text = "Adoption of Electric Vehicles Over Time"
legend_loc = "upper right" 

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(8, 5))  # Adjusting figure size

# Sustainable Initiative
color_ev = "#2ca02c"  # Earth tone green
color_ev_fill = "#a1dab4"
color_conv = "#d95f0e"  # Earth tone brown

ax.plot(
    years,
    ev_adoption,
    marker="s",
    color=color_ev,  
    label=line_label,
    linestyle="--"
)
ax.fill_between(
    years, ev_adoption - 3, ev_adoption + 3, color=color_ev_fill
)

# Traditional Methods
ax.errorbar(
    years,
    conventional_vehicles,
    yerr=error,
    fmt="o",
    color=color_conv,  
    label=errorbar_label,
    capsize=5,
)

# Customizing the plot
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_xlim(2008, 2026)
ax.set_ylim(0, 100)  
ax.legend(loc=legend_loc)
ax.grid(True, linestyle='--', linewidth=0.6)
ax.set_xticks([2010, 2012, 2014, 2016, 2018, 2020, 2022, 2024])
ax.set_title(title_text)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("CB_83.pdf", bbox_inches="tight")
