
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
days = np.arange(1, 8)  # Days of the week
screen_time = [2.5, 3, 2.8, 4, 3.5, 5, 4.2]  # Average Screen Time in hours
posts_made = [1, 2, 3, 5, 2, 4, 1]  # Number of Posts Made
days_labels = ["Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"]

# Labels and Title
xlabel = "Days of the Week"
time_ylabel = "Average Screen Time (hours)"
posts_ylabel = "Number of Posts Made"
title = "Weekly Social Media Activity"
legend_labels = ["Screen Time", "Posts Made"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax1 = plt.subplots(figsize=(10, 6))

# Plotting Screen Time
color_screen_time = "#FF5733"
color_posts_made = "#1f77b4"

ax1.plot(days, screen_time, "s-", color=color_screen_time, label=legend_labels[0], linewidth=2)
ax1.set_xlabel(xlabel)
ax1.set_ylabel(time_ylabel, color=color_screen_time)
ax1.tick_params(axis="y", labelcolor=color_screen_time)
ax1.set_ylim([1, 6])
ax1.set_xticks(days)
ax1.set_xticklabels(days_labels)

# Annotating data points for Screen Time
for i, txt in enumerate(screen_time):
    ax1.annotate(
        f"{txt}h",
        (days[i], screen_time[i]),
        textcoords="offset points",
        xytext=(0, 10),
        ha="center",
        color=color_screen_time
    )

# Create a twin Axes sharing the x-axis for Posts Made
ax2 = ax1.twinx()
ax2.plot(days, posts_made, "o-", color=color_posts_made, label=legend_labels[1], linewidth=2)
ax2.set_ylabel(posts_ylabel, color=color_posts_made)
ax2.tick_params(axis="y", labelcolor=color_posts_made)
ax2.set_ylim([0, 6])

# Annotating data points for Posts Made
for i, txt in enumerate(posts_made):
    ax2.annotate(
        f"{txt}",
        (days[i], posts_made[i]),
        textcoords="offset points",
        xytext=(0, -15),
        ha="center",
        color=color_posts_made
    )

# Title and Layout
fig.suptitle(title, fontsize=16)
fig.tight_layout()
fig.subplots_adjust(top=0.9)  # Adjust to make room for the title

# Legends
fig.legend(loc="upper center", bbox_to_anchor=(0.5, 1.05), ncol=2)

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("CB_87.pdf", bbox_inches="tight")
