
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# New dataset: age vs. percentage of time spent on social media
age = np.random.rand(100) * 50 + 10  # Ages between 10 and 60
social_media_usage = np.random.rand(100) * 60 + 10  # Usage between 10% and 70%
line_age = [15, 25, 35, 45, 55]
line_usage = [60, 55, 45, 35, 25]
scatter_name = "Survey Respondents"
line_name = "Trend Line"
xlabel = "Age"
ylabel = "Social Media Usage %"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Start with a square Figure
fig = plt.figure(figsize=(6, 6))
gs = fig.add_gridspec(
    2,
    1,
    height_ratios=(1, 4),
    left=0.1,
    right=0.9,
    bottom=0.1,
    top=0.9,
    wspace=0.0,
    hspace=0.0,
)

# Create the Axes
ax = fig.add_subplot(gs[1, 0])
ax_histx = fig.add_subplot(gs[0, 0], sharex=ax)

# Draw the scatter plot and marginals
ax_histx.tick_params(axis="x", labelbottom=False)

# the scatter plot
ax.scatter(age, social_media_usage, color="#8cb369", edgecolor="white", s=50, label=scatter_name)

# add a line on ax
ax.plot(
    line_age,
    line_usage,
    color="#ff6f59",
    linewidth=2,
    linestyle='-',
    marker="o",
    markersize=6,
    label=line_name,
)

# draw a diagonal line
ax.plot([0, 60], [0, 60], color="gray", linestyle="--")

# now determine nice limits by hand
binwidth = 5
xymax = max(np.max(np.abs(age)), np.max(np.abs(social_media_usage)))
lim = (int(xymax / binwidth) + 1) * binwidth
bins = np.arange(0, lim + binwidth, binwidth)
ax_histx.hist(age, bins=bins, color="#b3ffff", edgecolor="black")

# remove the y-axis labels
ax_histx.set_yticks([])

# remove the top, left, and right spines
ax_histx.spines["top"].set_visible(False)
ax_histx.spines["left"].set_visible(False)
ax_histx.spines["right"].set_visible(False)

ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

ax.set_xticks([0, 10, 20, 30, 40, 50, 60])
ax.set_yticks([0, 10, 20, 30, 40, 50, 60])
ax.set_xlim(5, 65)
ax.set_ylim(5, 75)

ax.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("CB_88.pdf", bbox_inches="tight")
