
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from scipy.stats import gaussian_kde

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Sample data for the line plot
data_bus = np.random.normal(30, 10, 100)
data_train = np.random.normal(25, 8, 100)
data_bike = np.random.normal(40, 15, 100)

kde_bus = gaussian_kde(data_bus)
kde_train = gaussian_kde(data_train)
kde_bike = gaussian_kde(data_bike)

x_range = np.linspace(0, 60, 100)
labels = ["Bus", "Train", "Bike"]
title = "Transportation Mode Travel Time Comparison"
xlabel = "Travel Time (minutes)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with specific size
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 6), gridspec_kw={"height_ratios": [3, 2]})

# Line plot with enhanced style
ax1.fill_between(x_range, kde_bus(x_range), color="#FFDDC1", alpha=0.4)
ax1.fill_between(x_range, kde_train(x_range), color="#D4A5A5", alpha=0.5)
ax1.fill_between(x_range, kde_bike(x_range), color="#A1C6EA", alpha=0.3)
ax1.plot(x_range, kde_bus(x_range), label=labels[0], color="#FF5733", linestyle="--", linewidth=2)
ax1.plot(x_range, kde_train(x_range), label=labels[1], color="#C70039", linestyle="-.", linewidth=2)
ax1.plot(x_range, kde_bike(x_range), label=labels[2], color="#581845", linestyle=":", linewidth=2)
ax1.legend(title=title, loc="upper right")
ax1.set_xticks([])
ax1.set_yticks([])

# Box plot with enhanced style
box = ax2.boxplot(
    [data_bus, data_train, data_bike], vert=False, patch_artist=True, medianprops={"color": "black"}
)
box_colors = ["#FF5733", "#C70039", "#581845"]
for patch, color in zip(box["boxes"], box_colors):
    patch.set_facecolor(color)

ax2.set_xlabel(xlabel)
ax2.set_yticks([])
ax2.set_xlim(0, 60)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("CB_92.pdf", bbox_inches="tight")
